/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   WxSysLog defines the message logger of WxLib

   Note: This class is not fully defined

  [Avoided C Use] ::syslog(...), openlog(...),closelog(...)
*/
#ifndef WXSYSLOG_H__
#define WXSYSLOG_H__
#define WXSYSLOG_VERSRIO 6

#include "wxret.h"
#include "wxstr.h"
#include <syslog.h>   // include constants for applications to use

class WxSysLog {
  public:
    //
    // [Syn] Write msg to the logger.
    //
    //       priority is bit-OR'd of [facility] and [level]
    //       
    //       level=
    //              LOG_EMERG	system is unusable
    //              LOG_ALERT	action must be taken immediately
    //              LOG_CRIT	critical conditions
    //              LOG_ERR	error conditions
    //              LOG_WARNING	warning conditions
    //              LOG_NOTICE	normal but significant condition
    //              LOG_INFO	informational
    //              LOG_DEBUG	debug-level messages
    //
    //     facility=
    //              LOG_KERN     kernel messages
    //              LOG_USER	 random user-level messages
    //              LOG_MAIL	 mail system
    //              LOG_DAEMON	 system daemons
    //              LOG_AUTH	 security/authorization messages
    //              LOG_SYSLOG	 messages generated internally by syslogd
    //              LOG_LPR	 line printer subsystem
    //              LOG_NEWS	 network news subsystem
    //              LOG_UUCP	 UUCP subsystem
    //              LOG_CRON	 clock daemon
    //              LOG_AUTHPRIV security/authorization messages (private)
    //              LOG_FTP	 ftp daemon
    //              LOG_LOCAL0 to LOG_LOCAL7 reserved for local use
    //
    // [Exception] Wx_general_error
    //             Wx_bad_alloc
    //             Wx_bad_errno
    //
    // [Ret] OK
    //
    static WxRet write(int priority,WxStr msg) throw(std::exception);
  private:
};

#endif
