/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2004)
*/

#ifndef WXSTR_H__
#define WXSTR_H__
#define WXSTR_VERSION 8

#include "wxret.h"
#include <string>

/*
  WxStr is a class of contiguous bytes
*/
class WxStr {
  public:
    typedef std::string::size_type size_type;
    typedef char CharT;
    static const char class_name[];
    WX_DECLARE_FAULT;

    WxStr() throw() : _str() {};
    WxStr(const WxStr& src) throw(std::exception);
    WxStr(const WxStr& src,size_type str_idx,size_type str_num) throw(std::exception,Fault);
    WxStr(const CharT* src) throw(std::exception,Fault);
    WxStr(const CharT* buf,size_type len) throw(std::exception,Fault);
    WxStr(size_type num,CharT ch) throw(std::exception);
    WxStr(const std::string& src) throw(std::exception);

    ~WxStr() throw() {};
    inline bool is_default(void) const throw()
              { return _str.empty(); };

    inline void reset(void) throw()
              { _str.clear(); };

    inline size_type size(void) const throw()
              { return _str.size(); };

    inline const CharT& operator [](size_type pos) const throw()
              { return _str[pos]; };
    inline CharT& operator [](size_type pos) throw()
              { return _str[pos]; };
    const CharT& at(size_type pos) const throw(std::exception,Fault);
    CharT& at(size_type pos) throw(std::exception,Fault);

    inline const CharT* data(void) const throw()
              { return _str.data(); };
    const CharT* c_str(void) const throw()
              { return _str.c_str(); };
    inline const std::string& std_string(void) const throw()
              { return _str; };

    void assign(const WxStr& src) throw(std::exception);
    WxRet assign(const WxStr& src,size_type str_idx,size_type str_num) throw(std::exception);
    WxRet assign(const CharT* src) throw(std::exception);
    WxRet assign(const CharT* buf,size_type blen) throw(std::exception);
    void assign(size_type num,CharT ch) throw(std::exception);

    const WxStr& operator =(const WxStr& src) throw(std::exception);
    const WxStr& operator =(const CharT* src) throw(std::exception,Fault);
    const WxStr& operator =(CharT ch) throw(std::exception);

    void swap(WxStr& rstr) throw()
              { _str.swap(rstr._str); };

    // append
    void append(const WxStr& src) throw(std::exception);
    const WxStr& operator +=(const WxStr& src) throw(std::exception);
    WxRet append(const WxStr& src,size_type str_idx,size_type str_num) throw(std::exception);
    WxRet append(const CharT* src) throw(std::exception);
    const WxStr& operator +=(const CharT* src) throw(std::exception,Fault);
    WxRet append(const CharT* buf,size_type blen) throw(std::exception);
    void append(size_type num,CharT ch) throw(std::exception);
    void append(CharT ch) throw(std::exception);
    const WxStr& operator +=(CharT ch) throw(std::exception);

    WxRet insert(size_type idx,const WxStr& src) throw(std::exception);
    WxRet insert(size_type idx,const WxStr& src, size_type src_idx,size_type src_num) throw(std::exception);
    WxRet insert(size_type idx,const CharT* src) throw(std::exception);
    WxRet insert(size_type idx,const CharT* buf,size_type blen) throw(std::exception);
    WxRet insert(size_type idx,size_type num,CharT ch) throw(std::exception);

    // erase
    WxRet erase(size_type idx) throw(std::exception);
    WxRet erase(size_type idx,size_type len) throw(std::exception);

    // resize
    void resize(size_type num) throw(std::exception);
    void resize(size_type num,CharT ch) throw(std::exception);

    // replace
    WxRet replace(size_type idx,size_type len,const WxStr& src) throw(std::exception);
    WxRet replace(size_type idx,size_type len,const WxStr& src,size_type src_idx,size_type src_num) throw(std::exception);
    WxRet replace(size_type idx,size_type len,const CharT* src) throw(std::exception);
    WxRet replace(size_type idx,size_type len,const CharT* buf,size_type blen) throw(std::exception);
    WxRet replace(size_type idx,size_type len,size_type num,CharT ch) throw(std::exception);

    // find
    WxRet find(size_type& res,size_type idx,const WxStr& str) const throw(std::exception);
    WxRet rfind(size_type& res,size_type idx,const WxStr& str) const throw(std::exception);

    //WxRet find(size_type& res,const WxStr& str,size_type str_idx,size_type str_len ) const throw(std::exception);
    //WxRet rfind(size_type& res,const WxStr& str,size_type str_idx,size_type str_len) const throw(std::exception);

    //WxRet find(size_type& res,CharT ch) const throw(std::exception);
    //WxRet rfind(size_type& res,CharT ch) const throw(std::exception);

    WxRet find(size_type& res,size_type idx,CharT ch) const throw(std::exception);
    WxRet rfind(size_type& res,size_type idx,CharT ch) const throw(std::exception);

    WxRet find(size_type& res,size_type idx,const CharT* cstr) const throw(std::exception);
    WxRet rfind(size_type& res,size_type idx,const CharT* cstr) const throw(std::exception);
    WxRet find(size_type& res,size_type idx,const CharT* buf,size_t blen) const throw(std::exception);
    WxRet rfind(size_type& res,size_type idx,const CharT* buf,size_t blen ) const throw(std::exception);

    // comparison
    inline bool operator ==(const WxStr& rhs) const throw()
              { return _str==rhs._str; };
    inline bool operator !=(const WxStr& rhs) const throw()
              { return _str!=rhs._str; };
    bool operator ==(const CharT* rhs) const throw(std::exception);
    bool operator !=(const CharT* rhs) const throw(std::exception);

    // compare
    int compare(const WxStr& str) const throw(std::exception);
    int compare(size_type idx, size_type len,const WxStr& str) const throw(std::exception,Fault);
    int compare(const CharT* cstr) const throw(std::exception,Fault);
    int compare(size_type, size_type,const CharT*) const throw(std::exception,Fault);
    int compare(size_type, size_type,const CharT*,size_type) const throw(std::exception,Fault);
  private:
    std::string _str;
/*
    operator +()
    compare
    (x)copy
    (x)substr
*/
  //friend WxStr operator +(const WxStr&,const WxStr&) throw(std::exception,Fault);
};

WxStr operator +(const WxStr& lhs,const WxStr& rhs) throw(std::exception);
WxStr operator +(const WxStr& str,const WxStr::CharT* cstr) throw(std::exception,WxStr::Fault);
WxStr operator +(const WxStr::CharT* cstr,const WxStr& str) throw(std::exception,WxStr::Fault);
WxStr operator +(const WxStr& str,WxStr::CharT ch) throw(std::exception);
WxStr operator +(WxStr::CharT ch,const WxStr& str) throw(std::exception);


namespace Wx {
extern WxStr what_is(const WxErrMsg& em) throw(std::exception);
extern WxStr what_is(const WxRet& em) throw(std::exception);
extern WxStr what_is(const Wx_SrcLoc& s) throw(std::exception);
extern WxStr what_is(const Wx_bad_alloc& e) throw(std::exception);
extern WxStr what_is(const Wx_except& e) throw(std::exception);
extern WxStr what_is(const Wx_general_error& e) throw(std::exception);
extern WxStr what_is(const Wx_bad_errno& e) throw(std::exception);
};

#include <iostream>

//
// Overloaded operator function for WxStr
//
// Note: This function is for convenience, not conforming to WxLib rules.
//
inline std::ostream& operator<< (std::ostream& os, const WxStr& str)
{
 os << str.std_string();
 return os;
};

#endif
