
#include "wxstr.h"
/*
 std::string exceptions are converted:
    std::length_error --> Wx_bad_alloc()
    std::out_of_range --> WXM_EINVAL

*/
const char WxStr::class_name[]="WxStr";

//
// [The C++ Standard Library] p509 does not indicate std::string copy operation
// will or not throw exception. I guess they will not.
//
WxStr::WxStr(const WxStr& src) throw(std::exception)
try : _str(src._str) {
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr::WxStr(const WxStr& src,size_type str_idx,size_type str_num) throw(std::exception,Fault)
try : _str(src._str,str_idx,str_num) {
}
catch(const std::out_of_range&) {
 WX_THROW( Fault(WXM_EINVAL) );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr::WxStr(const CharT* src) throw(std::exception,Fault)
try {
 if(src==0) {
   WX_THROW( Fault(WXM_EFAULT) );
 }
 _str.assign(src);
}
catch(const Fault&) {
  throw;
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr::WxStr(const CharT* buf,size_type len) throw(std::exception,Fault)
try {
 if(buf==0) {
   WX_THROW( Fault(WXM_EFAULT) );
 }
 _str.assign((const char*)buf,len);
}
catch(const Fault&) {
  throw;
}
catch(const std::length_error&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr::WxStr(size_type num,CharT ch) throw(std::exception)
try : _str(num,ch) {
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr::WxStr(const std::string& src) throw(std::exception)
try : _str(src) {
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//
//
//
const WxStr::CharT& WxStr::at(size_type pos) const throw(std::exception,Fault)
try{
 return _str.at(pos);
}
catch(const std::out_of_range&) {
 WX_THROW( Fault(WXM_EINVAL) );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr::CharT& WxStr::at(size_type pos) throw(std::exception,Fault)
try{
 return _str.at(pos); 
}
catch(const std::out_of_range&) {
 WX_THROW( Fault(WXM_EINVAL) );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//
// assign
//
void WxStr::assign(const WxStr& src) throw(std::exception)
try {
 _str.assign(src._str);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::assign(const WxStr& src,size_type str_idx,size_type str_num) throw(std::exception)
try {
 _str.assign(src._str,str_idx,str_num);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::assign(const CharT* src) throw(std::exception)
try {
 if(src==0) {
   WX_RETURN(WXM_EFAULT);
 }
 _str.assign(src);
 return(OK);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::assign(const CharT* buf,size_type blen) throw(std::exception)
try {
 if(buf==0) {
   WX_RETURN(WXM_EFAULT);
 }
 _str.assign((const char*)buf,blen);
 return(OK);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

void WxStr::assign(size_type num,CharT ch) throw(std::exception)
try {
 _str.assign(num,ch);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

const WxStr& WxStr::operator =(const WxStr& src) throw(std::exception)
try {
 _str.assign(src._str);
 return(*this);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

const WxStr& WxStr::operator =(const CharT* src) throw(std::exception,Fault)
try {
 if(src==0) {
   WX_THROW( Fault(WXM_EFAULT) );
 }
 _str=src;
 return(*this);
}
catch(const Fault&) {
 throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

const WxStr& WxStr::operator =(CharT ch) throw(std::exception)
try {
 _str=ch;
 return(*this);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//
// append
//
void WxStr::append(const WxStr& src) throw(std::exception)
try {
 _str.append(src._str);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

const WxStr& WxStr::operator +=(const WxStr& src) throw(std::exception)
try {
 _str.append(src._str);
 return(*this);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::append(const WxStr& src,size_type str_idx,size_type str_num) throw(std::exception)
try {
 _str.append(src._str,str_idx,str_num);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::append(const CharT* cstr) throw(std::exception)
try {
 if(cstr==0) {
   WX_RETURN(WXM_EFAULT);
 }
 _str.append(cstr);
 return(OK);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

const WxStr& WxStr::operator +=(const CharT* cstr) throw(std::exception,Fault)
try {
 if(cstr==0) {
   WX_THROW( Fault(WXM_EFAULT) );
 }
 _str.append(cstr);
 return(*this);
}
catch(const Fault&) {
 throw;
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::append(const CharT* buf,size_type blen) throw(std::exception)
try {
 if(buf==0) {
   WX_RETURN(WXM_EFAULT);
 }
 _str.append((const char*)buf,blen);
 return(OK);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

void WxStr::append(size_type num,CharT ch) throw(std::exception)
try {
 _str.append(num,ch);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

void WxStr::append(CharT ch) throw(std::exception)
try {
 _str.push_back(ch);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

const WxStr& WxStr::operator +=(CharT ch) throw(std::exception)
try {
 _str+=ch;
 return(*this);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//
// insert
//
WxRet WxStr::insert(size_type idx,const WxStr& src) throw(std::exception)
try {
 _str.insert(idx,src._str);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::insert(size_type idx,const WxStr& src, size_type src_idx,size_type src_num) throw(std::exception)
try {
 _str.insert(idx,src._str,src_idx,src_num);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::insert(size_type idx,const CharT* src) throw(std::exception)
try {
 if(src==0) {
   WX_RETURN(WXM_EFAULT);
 }
 _str.insert(idx,src);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::insert(size_type idx,const CharT* buf,size_type blen) throw(std::exception)
try {
 if(buf==0) {
   WX_RETURN(WXM_EFAULT);
 }
 _str.insert(idx,(const char*)buf,blen);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::insert(size_type idx,size_type num,CharT ch) throw(std::exception)
try {
 _str.insert(idx,num,ch);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//
// erase
//
WxRet WxStr::erase(size_type idx) throw(std::exception)
try {
 _str.erase(idx);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::erase(size_type idx,size_type len) throw(std::exception)
try {
 _str.erase(idx,len);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//
// resize
//
void WxStr::resize(size_type num) throw(std::exception)
try {
 _str.resize(num);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

void WxStr::resize(size_type num,CharT ch) throw(std::exception)
try {
 _str.resize(num,ch);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//
// replace
//
WxRet WxStr::replace(size_type idx,size_type len,const WxStr& src) throw(std::exception)
try {
 _str.replace(idx,len,src._str);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::replace(size_type idx,size_type len,const WxStr& src,size_type src_idx,size_type src_num) throw(std::exception)
try {
 _str.replace(idx,len,src._str,src_idx,src_num);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::replace(size_type idx,size_type len,const CharT* src) throw(std::exception)
try {
 if(src==0) {
   WX_RETURN(WXM_EFAULT);
 }
 _str.replace(idx,len,src);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::replace(size_type idx,size_type len,const CharT* buf,size_type blen) throw(std::exception)
try {
 if(buf==0) {
   WX_RETURN(WXM_EFAULT);
 }
 _str.replace(idx,len,(const char*)buf,blen);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::replace(size_type idx,size_type len,size_type num,CharT ch) throw(std::exception)
try {
 _str.replace(idx,len,num,ch);
 return(OK);
}
catch(const std::out_of_range&) {
 WX_RETURN(WXM_EINVAL);
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//
// find
//
WxRet WxStr::find(WxStr::size_type& res, size_type idx,const WxStr& str) const throw(std::exception)
try {
 std::string::size_type t=_str.find(str._str,idx);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::rfind(WxStr::size_type& res, size_type idx,const WxStr& str) const throw(std::exception)
try {
 std::string::size_type t=_str.rfind(str._str,idx);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

/*
WxRet WxStr::find(WxStr::size_type& res,const WxStr& str,size_type str_idx,size_type str_num) const throw(std::exception)
try {
 std::string::size_type t=_str.find(str._str,str_idx,str_num);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::rfind(WxStr::size_type& res,const WxStr& str,size_type str_idx,size_type str_num) const throw(std::exception)
try {
 std::string::size_type t=_str.rfind(str._str,str_idx,str_num);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::find(WxStr::size_type& res, CharT ch) const throw(std::exception)
try {
 std::string::size_type t=_str.find(ch);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::rfind(WxStr::size_type& res, CharT ch) const throw(std::exception)
try {
 std::string::size_type t=_str.rfind(ch);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};
*/

WxRet WxStr::find(WxStr::size_type& res, size_type idx, CharT ch) const throw(std::exception)
try {
 std::string::size_type t=_str.find(ch,idx);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::rfind(WxStr::size_type& res, size_type idx, CharT ch) const throw(std::exception)
try {
 std::string::size_type t=_str.rfind(ch,idx);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::find(size_type& res,size_type idx,const CharT* cstr) const throw(std::exception)
try {
 if(cstr==0) {
   WX_RETURN(WXM_EFAULT);
 }
 std::string::size_type t=_str.find(cstr,idx);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::rfind(size_type& res,size_type idx,const CharT* cstr) const throw(std::exception)
try {
 if(cstr==0) {
   WX_RETURN(WXM_EFAULT);
 }
 std::string::size_type t=_str.rfind(cstr,idx);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::find(size_type& res,size_type idx,const CharT* buf,size_t blen) const throw(std::exception)
try {
 if(buf==0) {
   WX_RETURN(WXM_EFAULT);
 }
 std::string::size_type t=_str.find(buf,idx,blen);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxRet WxStr::rfind(size_type& res,size_type idx,const CharT* buf,size_t blen) const throw(std::exception)
try {
 if(buf==0) {
   WX_RETURN(WXM_EFAULT);
 }
 std::string::size_type t=_str.rfind(buf,idx,blen);
 if(t==std::string::npos) {
   WX_RETURN(WXM_ESRCH);
 }
 res=t;
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

bool WxStr::operator ==(const CharT* rhs) const throw(std::exception)
try {
 if(rhs==0) {
   return(false);     // no WxStr == null
 }
 return( _str==rhs );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

bool WxStr::operator !=(const CharT* rhs) const throw(std::exception)
try {
 if(rhs==0) {
   return(true);      // no WxStr == null
 }
 return( _str!=rhs );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

int WxStr::compare(const WxStr& str) const throw(std::exception)
try {
 return _str.compare(str._str);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

int WxStr::compare(size_type idx, size_type len,const WxStr& str) const throw(std::exception,Fault)
try {
 return _str.compare(idx,len,str._str);
}
catch(const std::out_of_range&) {
 WX_THROW( Fault(WXM_EINVAL) );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

int WxStr::compare(const CharT* cstr) const throw(std::exception,Fault)
try {
 if(cstr==0) {
   WX_THROW( Fault(WXM_EFAULT) );
 }
 return _str.compare(cstr);
}
catch(const Fault&) {
 throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

int WxStr::compare(size_type idx, size_type len,const CharT* cstr) const throw(std::exception,Fault)
try {
 if(cstr==0) {
   WX_THROW( Fault(WXM_EFAULT) );
 }
 return _str.compare(idx,len,cstr);
}
catch(const Fault&) {
 throw;
}
catch(const std::out_of_range&) {
 WX_THROW( Fault(WXM_EINVAL) );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

int WxStr::compare(size_type idx, size_type len,const CharT* buf,size_type blen) const throw(std::exception,Fault)
try {
 if(buf==0) {
   WX_THROW( Fault(WXM_EFAULT) );
 }
 return _str.compare(idx,len,buf,blen);
}
catch(const Fault&) {
 throw;
}
catch(const std::length_error&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const std::out_of_range&) {
 WX_THROW( Fault(WXM_EINVAL) );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//----------------------------------------------------------------------
WxStr operator +(const WxStr& lhs,const WxStr& rhs) throw(std::exception)
try {
 WxStr res(lhs);
 res+=rhs;
 return(res);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr operator +(const WxStr& str,const WxStr::CharT* cstr) throw(std::exception,WxStr::Fault)
try {
 WxStr res(str);
 res+=cstr;
 return(res);
}
catch(const WxStr::Fault&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr operator +(const WxStr::CharT* cstr,const WxStr& str) throw(std::exception,WxStr::Fault)
try {
 WxStr res(cstr);
 res+=str;
 return(res);
}
catch(const WxStr::Fault&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr operator +(WxStr::CharT ch,const WxStr& str) throw(std::exception)
try {
 WxStr res(1,ch);
 res+=str;
 return(res);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

WxStr operator +(const WxStr& str,WxStr::CharT ch) throw(std::exception)
try {
 WxStr res(str);
 res+=ch;
 return(res);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//----------------------------------------------------------------

//
// [Syn] Make string representation of the given parameters. 
//
// [Exception] Wx_bad_alloc
//             Wx_general_error
//
// [Ret] string representation of the parameters in the form:
//        file_name ,'(' ,line_num ,')'
//
static WxStr mkstr_sli(const char *file_name,int line_num) throw(std::exception)
try {
 WxStr nstr;

 if(file_name!=0) {
#ifndef WX_SHORT_SLI
   nstr=file_name;
#else
  //
  // Sample the first MaxFlen characters of file_name or until the dot 
  // character as the source file name information.
  //
  const int MaxFlen=8;  
  int flen;
  for(flen=0; flen<MaxFlen; ++flen) {
     const char ch=file_name[flen];
     if((ch==0)||(ch=='.')) {
       break;
     }
  }
  nstr.assign(file_name,0,flen);
#endif
 };

#ifndef WX_SHORT_SLI
 nstr+='(';
#endif

 //
 // Convert line_num number
 // 
 char dbuf[12];   // enough for long int
 std::div_t dt;
 int n;

 if(line_num<0) {
   dt.quot=-line_num;
   nstr+='-';
 } else {
   dt.quot=line_num;
 }
  
 n=0;
 do {
   dt=std::div(dt.quot,10);
   dbuf[n++]=(char)(dt.rem);
 } while(dt.quot>0);

 for(--n; n>=0; --n) {
   const char ch=dbuf[n];
   nstr+= (ch>9)?  (ch+'7'):(ch+'0');
 }
#ifndef WX_SHORT_SLI
 nstr+=')';
#endif
 return(nstr);   // see note1
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(const WxStr::Fault& e) {
 WX_THROW( Wx_general_error() );
}
catch(...) {
 WX_THROW( Wx_general_error() );
};

//----------------------------------------------------------------
WxStr Wx::what_is(const WxErrMsg& em) throw(std::exception)
try {
 return WxStr(em.c_errstr());
}
catch(const WxStr::Fault& e) {
 WX_THROW( Wx_general_error() );
}
catch(...) {
  WX_THROW( Wx_general_error() );
};
 
WxStr Wx::what_is(const Wx_SrcLoc& s) throw(std::exception)
try {
 return mkstr_sli(s.src_file(),s.src_line());
}
catch(const WxStr::Fault& e) {
 WX_THROW( Wx_general_error() );
}
catch(...) {
  WX_THROW( Wx_general_error() );
};

WxStr Wx::what_is(const WxRet& r) throw(std::exception)
try {
 if(r.sli_ptr()==0) {
   return r.c_errstr(); 
 }
 return Wx::what_is(*r.sli_ptr()) + ": " + r.c_errstr();
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const WxStr::Fault& e) {
 WX_THROW( Wx_general_error() );
}
catch(...) {
  WX_THROW( Wx_general_error() );
};

WxStr Wx::what_is(const Wx_bad_alloc& eobj) throw(std::exception)
try {
 if(eobj.sli_ptr()==0) {
   return WxStr(Wx_bad_alloc::class_name);
 }
 return Wx::what_is(*eobj.sli_ptr()) + ": " + Wx_bad_alloc::class_name;
}
catch(const WxStr::Fault& e) {
 WX_THROW( Wx_general_error() );
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const Wx_general_error&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW( Wx_general_error() );
};

WxStr Wx::what_is(const Wx_except& eobj) throw(std::exception)
try {
 if(eobj.sli_ptr()==0) {
   return WxStr(Wx_except::class_name);
 }
 return Wx::what_is(*eobj.sli_ptr()) + ": " + Wx_except::class_name;
}
catch(const WxStr::Fault& e) {
 WX_THROW( Wx_general_error() );
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const Wx_general_error&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW( Wx_general_error() );     
};

WxStr Wx::what_is(const Wx_general_error& eobj) throw(std::exception)
try {
 if(eobj.sli_ptr()==0) {
   return WxStr(Wx_general_error::class_name);
 }
 return Wx::what_is(*eobj.sli_ptr()) + ": " + Wx_general_error::class_name;
}
catch(const WxStr::Fault& e) {
 WX_THROW( Wx_general_error() );
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const Wx_general_error&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW( Wx_general_error() );
};

WxStr Wx::what_is(const Wx_bad_errno& eobj) throw(std::exception)
try {
 if(eobj.sli_ptr()==0) {
   return WxStr(Wx_bad_errno::class_name);
 }
 WxStr ostr=Wx::what_is(*eobj.sli_ptr()) +": " +Wx_bad_errno::class_name +'(';

 //
 // Convert line number
 //
 assert(WxErrMsg::MaxErrNo<=999);
 char dbuf[4];   // enough for errno
 std::div_t dt;
 int n;

 if(eobj.value()<0) {
   dt.quot=-eobj.value();
   ostr+='-';
 } else {
   dt.quot=eobj.value();
 }
  
 n=0;
 do {
   dt=std::div(dt.quot,10);
   dbuf[n++]=(char)(dt.rem);
 } while(dt.quot>0);

 for(n--; n>=0; n--) {
   const char ch=dbuf[n];
   ostr+= (ch>9)?  (ch+'7'):(ch+'0');
 }
 return ostr+=')';
}
catch(const WxStr::Fault& e) {
 WX_THROW( Wx_general_error() );
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const Wx_general_error&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW( Wx_general_error() );
};
