/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   This file should conform to the documentation in file wxsockfile.3wx

  [Avoided C Use] socket,shutdown,bind,listen,accept,connect,getsockname,getpeername
*/

#ifndef WXSOCKFILE_H__
#define WXSOCKFILE_H__
#define WXSOCKFILE_VERSION 8

#include "wxbyteflow.h"
#include "wx_sockaddr.h"
#include <sys/types.h>
#include <sys/socket.h>
#include "wxstr.h"
//#include <arpa/inet.h>

/*
*/
class WxSockFile : public WxByteFlow {
  public:
    static const char class_name[];
    WX_DECLARE_FAULT;

    WxSockFile() throw()
              : WxByteFlow(), _family(DefaultFamily) {};

    WxSockFile(const WxSockFile &src) throw(std::exception,WxRet);

    virtual ~WxSockFile() throw(std::exception);

    // [Derived]
    //bool is_default(void) const throw()

    // [Derived]
    // WxFileHandle fh(void) const throw()

    // [Derived]
    // WxRet stat(WxFileStat& filestat) const throw(std::exception);

    virtual WxRet reset(void) throw(std::exception)
              { _family=DefaultFamily; return WxByteFlow::reset(); };


    // [Derived]
    // virtual WxRet read(void *buf, size_t count, size_t *n_read) throw(std::exception);

    // [Derived]
    // virtual WxRet max_read(void* buf,size_t count,size_t* n_read) throw(std::exception)

    // [Derived]
    // virtual WxRet write(const void *buf, size_t count, size_t *n_written) throw(std::exception)

    virtual WxRet drain(void) throw(std::exception);

    int family(void) const throw()
              { return _family; };

    virtual WxRet open(int domain, int type, int proto=0) throw(std::exception);

    virtual WxRet assignf(WxFileHandle fh) throw(std::exception);

    virtual WxRet assignf(const WxSockFile& src) throw(std::exception);

    virtual WxRet shutdown(int how) throw(std::exception);
    
    virtual WxRet bind(const Wx_SockAddr& addr) throw(std::exception);

    virtual WxRet listen(int backlog) throw(std::exception);

    virtual WxRet accept(WxSockFile &skt, Wx_SockAddr &addr) throw(std::exception);

    virtual WxRet connect(const Wx_SockAddr& peer_addr) throw(std::exception);

    WxRet get_addr(Wx_SockAddr& addr) const throw(std::exception);

    WxRet get_peer_addr(Wx_SockAddr& addr) const throw(std::exception);

    // [Derived]
    // WxRet wx_set_fh(WxFileHandle fh) throw(std::exception)

    //
    // [Internal] Set file descriptor of this object to exactly the open fh and,
    //            family specified the protocol family of fh.
    //
    // [Exception] Wx_general_error
    //             Wx_bad_alloc
    // 
    // [Ret] OK     Succeed
    //       WXM_EINVAL fd is not an open file descriptor
    //       WXM_NDEFAULT object is not default
    // 
    // [Refer]
    //
    WxRet wx_set_fh(WxFileHandle fh,int family) throw(std::exception);

  protected:
    //
    // [Syn] Construct object from the open fd
    //
    // Note: This is not a direct copy of fd but a duplicate by dup()
    //
    // [Exception] Wx_general_error
    //             Wx_bad_alloc
    //             Wx_bad_errno
    // 
    // [Exception] Fault
    //       WXM_EINVAL fd is not an open fd
    //       WXM_EBADF  fd is not valid for the operation
    //       WXM_EMFILE too many open fd
    //
    // Note: errmsg is converted from the errno ::dup returned
    //
    // [Refer] ::dup(int)
    //
    WxSockFile(WxFileHandle fh) throw(std::exception,WxRet)
              : WxByteFlow(fh), _family(DefaultFamily) {};

    // [Derived]
    // WxRet wx_fcntl(int cmd,int *ret_f) const throw(std::exception)
    // WxRet wx_fcntl(int cmd, long arg, int *ret_f) const throw(std::exception)
    // WxRet wx_fcntl(int cmd, struct flock *lock,int *ret_f) const throw(std::exception)

  private:
    enum { DefaultFamily=PF_UNSPEC };
    int _family;

    WxRet wx_set_fd(int fd) throw(std::exception); // disable
    WxRet wx_open(const WxPathName& pathname,int f); // disabled
    WxRet wx_open(const WxPathName& pathname, int f, mode_t m); // disabled
    WxRet wx_assign(const WxByteFlow& byteflow); // disabled
    void wx_overwrite(int fd) throw(); // disabled

    const WxSockFile &operator=(const WxSockFile &rhs) throw(); // not to use 
    WxRet close(void); // not to use, see Wx__Handle::close(), yet to define
};

#endif
