/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxsockaddrlocal.h"
#include <cstring>

const char WxSockAddrLocal::class_name[]="WxSockAddrLocal";

class Wx__Local__ {
  public:
    Wx__Local__() {
        //
        // Check 1.sizeof(_saddr.sun_family)==Wx_SockAddr::DefaultSockLen;
        //       2._saddr.sun_path index==Wx_SockAddr::DefaultSockLen;
        //
        struct sockaddr_un _saddr;
        if(sizeof(_saddr.sun_family)!=Wx_SockAddr::DefaultSockLen) {
          WX_ABORT();
        }
        const char* p0=(const char*)&_saddr;
        const char* p1=(const char*)_saddr.sun_path;
        if(p1-p0!=size_t(Wx_SockAddr::DefaultSockLen)) {
          WX_ABORT();
        }
      };
} const static wx__local__;

WxRet WxSockAddrLocal::_assign(const WxPathName& path) throw(std::exception)
try {
 size_t plen=path.pathname().size();
 // ref. note1
 if(plen>=sizeof(_saddr.sun_path)) {
   WX_RETURN(WXM_ENAMETOOLONG);
 }
 _saddr.sun_family=AF_LOCAL;
 std::memcpy(_saddr.sun_path,path.pathname().c_str(),plen+1);
 _slen=sizeof(_saddr.sun_family)+plen;
 return(OK); 
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxSockAddrLocal::WxSockAddrLocal(const WxSockAddrLocal &src) throw(std::exception)
try {
 if(&src==this) {
   WX_THROW(Wx_general_error());  // Looking for trouble
 }
 if(src._slen<DefaultSockLen) {
   WX_THROW(Wx_general_error());  // assertion failure
 }
 if(src._saddr.sun_family!=AF_LOCAL) {
   WX_THROW(Wx_general_error());  // assertion failure
 }
 _saddr=src._saddr;
 _slen=src._slen;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxSockAddrLocal::WxSockAddrLocal(const WxPathName& path) throw(std::exception,WxRet)
try {
  const WxRet r=_assign(path);
  if(r!=OK) {
    WX_THROW( Fault(r) );
  }
}
catch(const WxSockAddrLocal::Fault&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

void WxSockAddrLocal::assign(const WxSockAddrLocal &src) throw(std::exception)
try {
 if(&src==this) {
   return;
 }
 if(src._slen<DefaultSockLen) {
   WX_THROW(Wx_general_error());  // assertion failure
 }
 if(src._saddr.sun_family!=AF_LOCAL) {
   WX_THROW(Wx_general_error());  // assertion failure
 }
 _saddr=src._saddr;
 _slen=src._slen;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxRet WxSockAddrLocal::get_notation(WxStr& addr) const throw(std::exception)
try {
 if(_slen<=DefaultSockLen) {
   if(_slen==DefaultSockLen) {
     WX_RETURN(WXM_ENOENT);
   }
   WX_THROW(Wx_general_error());   // _slen should >= sizeof(_saddr.sun_family)
 }
 if(_saddr.sun_family!=AF_LOCAL) {
   WX_THROW(Wx_general_error());
 }
 // ref. note1
 addr.assign(_saddr.sun_path,_slen-sizeof(_saddr.sun_family));
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

bool WxSockAddrLocal::operator==(const WxSockAddrLocal &rhs) const throw(std::exception)
try {
 if(_slen!=rhs._slen) {
   return(false);
 }
 if(_saddr.sun_family!=rhs._saddr.sun_family) {
   WX_THROW(Wx_general_error());
 }
 if(_slen<=DefaultSockLen) {
   if(_slen!=DefaultSockLen) {
     WX_THROW(Wx_general_error());
   }
   return(rhs.is_default());
 }
 // ref. note1
 return std::memcmp(&_saddr.sun_path,&rhs._saddr.sun_path
                   ,_slen-sizeof(_saddr.sun_family))==0? true:false;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

/*
  note1: The string in _saddr.sun_path is zero ended. but not counted in _slen.
*/
