/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxsockaddrinet.h"
#include <cstring>
//#include <netinet/in.h> 

const char WxSockAddrINet::class_name[]="WxSockAddrINet";

class Wx__Local__ {
  public:
    Wx__Local__() {
        //
        // Check sizeof(_saddr.sin_family)==Wx_SockAddr::DefaultSockLen;
        //
        struct sockaddr_in _saddr;
        if(sizeof(_saddr.sin_family)!=Wx_SockAddr::DefaultSockLen) {
          WX_ABORT();
        }
      };
} const static wx__local__;

void WxSockAddrINet::_assign(const WxSockAddrINet &src) throw(std::exception)
try {
 if(&src==this) {
   return;
 }
 if(src._slen<DefaultSockLen) {
   WX_THROW(Wx_general_error());  // assertion failure
 }
 if(src._saddr.sin_family!=AF_INET) {
   WX_THROW(Wx_general_error());  // assertion failure
 }
 _saddr=src._saddr;
 _slen=src._slen;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

void WxSockAddrINet::_assign(ulong ip,ushort port) throw(std::exception)
try {
 std::memset(&_saddr.sin_addr,0,sizeof(_saddr.sin_addr));
 _saddr.sin_family=AF_INET;
 _saddr.sin_addr.s_addr=::htonl(ip);
 _saddr.sin_port=::htons(port);
 _slen=sizeof(_saddr);
 return;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxRet WxSockAddrINet::_assign(const std::string& addr, ushort  port) throw(std::exception)
try {
 std::memset(&_saddr.sin_addr,0,sizeof(_saddr.sin_addr));
 _saddr.sin_family=AF_INET;
 _saddr.sin_port=::htons(port);
 _slen=sizeof(_saddr);
 int v=::inet_pton(AF_INET,addr.c_str(),&_saddr.sin_addr);
 if(v<=0) {
   if(v==0) {
     WX_RETURN(WXM_EADDRNOTAVAIL);  // string in addr not recognizable
   }
   WX_RETURN(WxErrMsg(errno));
 }
 return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxSockAddrINet::WxSockAddrINet(const WxSockAddrINet &src) throw(std::exception)
try {
 if(&src==this) {
  WX_THROW(Wx_general_error());  // Looking for trouble
 }
 if(src._slen<DefaultSockLen) {
   WX_THROW(Wx_general_error());  // assertion failure
 }
 if(src._saddr.sin_family!=AF_INET) {
   WX_THROW(Wx_general_error());  // assertion failure
 }
 _saddr=src._saddr;
 _slen=src._slen;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxSockAddrINet::WxSockAddrINet(ulong ip, ushort port) throw(std::exception)
try {
 _assign(ip,port);
 return;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxSockAddrINet::WxSockAddrINet(const WxStr& addr, ushort  port) throw(std::exception,WxRet)
try {
  const WxRet r=_assign(addr.std_string(),port);
  if(r!=OK) {
    WX_THROW( Fault(r) );
  }
}
catch(const WxSockAddrINet::Fault&) {
  throw;
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxRet WxSockAddrINet::get_notation(WxStr& addr) const throw(std::exception)
try {
 if(_slen<=DefaultSockLen) {
   if(_slen==DefaultSockLen) {
     WX_RETURN(WXM_ENOENT);
   }
   WX_THROW(Wx_general_error());  // assertion failure
 }
 if(_saddr.sin_family!=AF_INET) {
   WX_THROW(Wx_general_error());  // assertion failure
 }
 char abuf[INET_ADDRSTRLEN];   // ref. UNP1,p76
 if(::inet_ntop(AF_INET,&_saddr.sin_addr,abuf,sizeof(abuf))==NULL) {
   const int v=errno;
   if(v==ENOSPC) {
     WX_THROW( Wx_bad_errno(v) );    // should not happen
   }
   WX_RETURN(WxErrMsg(v));
 }
 addr=abuf;
 return(OK);
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

bool WxSockAddrINet::operator==(const WxSockAddrINet &rhs) const throw(std::exception)
try {
 if(_slen!=rhs._slen) {
   return false;
 }
 if(_saddr.sin_family!=rhs._saddr.sin_family) {
   WX_THROW(Wx_general_error());
 }
 if(_slen<=DefaultSockLen) {
   if(_slen!=DefaultSockLen) {
     WX_THROW(Wx_general_error());
   }
   return(rhs.is_default());
 }
 if(_saddr.sin_port!=rhs._saddr.sin_port) {
   return false;
 }
 return std::memcmp(&_saddr.sin_addr,&rhs._saddr.sin_addr,
                    sizeof(_saddr.sin_addr))==0? true:false;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};
