/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

  wxr_errmsg.h defines WxErrMsg
  wxr_ret.h defines WxRet,Wx_SrcLoc
  wxr_except.h defines Wx_bad_alloc, Wx_except, Wx_general_error, 
                       Wx_bad_errno

  Note: Add -lpthread -lrt to g++ linker options
*/
#ifndef WXRET_H__
#define WXRET_H__

#include "wxreqs.h"
#include <stdexcept>
#include "wxdefs.h"

//
// Note: Order of these included files is significant. They are as parts of
//       this file.
//
#include "wxr_errmsg.h"
#include "wxr_srcloc.h"
#include "wxr_ret.h"
#include "wxr_except.h"

/*
  This macro is used to declare class Fault exception in the name space it 
  is expanded.

  Warning: Class contains no vtbl, this may not be right.
*/
#define WX_DECLARE_FAULT \
    class Fault : public WxRet {\
      public:\
        inline Fault() throw()\
           : WxRet() {};\
        inline Fault(const Fault& e) throw()\
           : WxRet(e) {};\
        inline Fault(const WxRet& e) throw()\
           : WxRet(e) {};\
        inline const Fault& set_sli(const Wx_SrcLoc* s) throw()\
              { WxRet::set_sli(s); return(*this); };\
        inline const Wx_SrcLoc* sli_ptr(void) const throw()\
              { return WxRet::sli_ptr(); };\
      };

/*
  The following macros are defined to hide Wx_SrcLoc and to save typings.

  Note: gcc 3.2.2 found to optimize the static declared Wx_SrcLoc
*/

//
// [Macro] Set the source location information in r to where it is.
//         r should be an object that has set_sli(..) defined as
//         const T& set_sli(const Wx_SrcLoc*)
//
//template<class T>
//void Wx_set_here(T& t) { t.set_sli(&wx__sl); };

#define WX_HERE(r) { static const Wx_SrcLoc wx__sl(__FILE__,__LINE__);\
		 (r).set_sli(&wx__sl); }

//
// [Macro] Return WxRet from rm
//         rm is intended the argument that WxRet ctor accepts
//
#define WX_RETURN(rm) { static const Wx_SrcLoc wx__sl(__FILE__,__LINE__);\
		  return WxRet(rm).set_sli(&wx__sl); }

//
// [Macro] Throw exception object obj
//         obj is intened in the ctor form T(...) or an object that has
//         set_sli(..) defined by the rule.
//
// Note: obj is not enclosed (won't compile if obj is like "T()")
//
#define WX_THROW(obj) { static const Wx_SrcLoc wx__sl(__FILE__,__LINE__);\
		  throw obj.set_sli(&wx__sl); }

#endif
