/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxret.h"
#include <pthread.h>
#include <vector>
#include <cstdlib>

//-------------------------------------------------------
// Note: Order of code is significant
//-------------------------------------------------------

//
// WxErrMsg constants. Text is the same as that for C-library errno
//
 const WxErrMsg OK              =WxErrMsg::enroll("Success");
 const WxErrMsg WXM_EPERM	=WxErrMsg::enroll("Operation not permitted");
 const WxErrMsg WXM_ENOENT	=WxErrMsg::enroll("No such file or directory");
 const WxErrMsg WXM_ESRCH	=WxErrMsg::enroll("No such process");
 const WxErrMsg WXM_EINTR	=WxErrMsg::enroll("Interrupted system call");
 const WxErrMsg WXM_EIO		=WxErrMsg::enroll("Input/output error");
 const WxErrMsg WXM_ENXIO	=WxErrMsg::enroll("No such device or address");
 const WxErrMsg WXM_E2BIG	=WxErrMsg::enroll("Arg list too long");
 const WxErrMsg WXM_ENOEXEC	=WxErrMsg::enroll("Exec format error");
 const WxErrMsg WXM_EBADF	=WxErrMsg::enroll("Bad file number");
 const WxErrMsg WXM_ECHILD	=WxErrMsg::enroll("No child processes");
 const WxErrMsg WXM_EAGAIN	=WxErrMsg::enroll("Try again");
 const WxErrMsg WXM_ENOMEM	=WxErrMsg::enroll("Out of memory");
 const WxErrMsg WXM_EACCES	=WxErrMsg::enroll("Permission denied");
 const WxErrMsg WXM_EFAULT	=WxErrMsg::enroll("Bad address");
 const WxErrMsg WXM_ENOTBLK	=WxErrMsg::enroll("Block device required");
 const WxErrMsg WXM_EBUSY	=WxErrMsg::enroll("Device or resource busy");
 const WxErrMsg WXM_EEXIST	=WxErrMsg::enroll("File exists");
 const WxErrMsg WXM_EXDEV	=WxErrMsg::enroll("Cross-device link");
 const WxErrMsg WXM_ENODEV	=WxErrMsg::enroll("No such device");
 const WxErrMsg WXM_ENOTDIR	=WxErrMsg::enroll("Not a directory");
 const WxErrMsg WXM_EISDIR	=WxErrMsg::enroll("Is a directory");
 const WxErrMsg WXM_EINVAL	=WxErrMsg::enroll("Invalid argument");
 const WxErrMsg WXM_ENFILE	=WxErrMsg::enroll("File table overflow");
 const WxErrMsg WXM_EMFILE	=WxErrMsg::enroll("Too many open files");
 const WxErrMsg WXM_ENOTTY	=WxErrMsg::enroll("Not a typewriter");
 const WxErrMsg WXM_ETXTBSY	=WxErrMsg::enroll("Text file busy");
 const WxErrMsg WXM_EFBIG	=WxErrMsg::enroll("File too large");
 const WxErrMsg WXM_ENOSPC	=WxErrMsg::enroll("No space left on device");
 const WxErrMsg WXM_ESPIPE	=WxErrMsg::enroll("Illegal seek");
 const WxErrMsg WXM_EROFS	=WxErrMsg::enroll("Read-only file system");
 const WxErrMsg WXM_EMLINK	=WxErrMsg::enroll("Too many links");
 const WxErrMsg WXM_EPIPE	=WxErrMsg::enroll("Broken pipe");
 const WxErrMsg WXM_EDOM	=WxErrMsg::enroll("Math argument out of domain of func");
 const WxErrMsg WXM_ERANGE	=WxErrMsg::enroll("Math result not representable");
 const WxErrMsg WXM_EDEADLK	=WxErrMsg::enroll("Resource deadlock would occur");
 const WxErrMsg WXM_ENAMETOOLONG=WxErrMsg::enroll("File name too long");
 const WxErrMsg WXM_ENOLCK	=WxErrMsg::enroll("No record locks available");
 const WxErrMsg WXM_ENOSYS	=WxErrMsg::enroll("Function not implemented");
 const WxErrMsg WXM_ENOTEMPTY	=WxErrMsg::enroll("Directory not empty");
 const WxErrMsg WXM_ELOOP	=WxErrMsg::enroll("Too many symbolic links encountered");
 const WxErrMsg WXM_EWOULDBLOCK =WXM_EAGAIN;
 const WxErrMsg WXM_E41         =WxErrMsg::enroll("Unknown error 41"); 
 const WxErrMsg WXM_ENOMSG	=WxErrMsg::enroll("No message of desired type");
 const WxErrMsg WXM_EIDRM	=WxErrMsg::enroll("Identifier removed");
 const WxErrMsg WXM_ECHRNG	=WxErrMsg::enroll("Channel number out of range");
 const WxErrMsg WXM_EL2NSYNC	=WxErrMsg::enroll("Level 2 not synchronized");
 const WxErrMsg WXM_EL3HLT	=WxErrMsg::enroll("Level 3 halted");
 const WxErrMsg WXM_EL3RST	=WxErrMsg::enroll("Level 3 reset");
 const WxErrMsg WXM_ELNRNG	=WxErrMsg::enroll("Link number out of range");
 const WxErrMsg WXM_EUNATCH	=WxErrMsg::enroll("Protocol driver not attached");
 const WxErrMsg WXM_ENOCSI	=WxErrMsg::enroll("No CSI structure available");
 const WxErrMsg WXM_EL2HLT	=WxErrMsg::enroll("Level 2 halted");
 const WxErrMsg WXM_EBADE	=WxErrMsg::enroll("Invalid exchange");
 const WxErrMsg WXM_EBADR	=WxErrMsg::enroll("Invalid request descriptor");
 const WxErrMsg WXM_EXFULL	=WxErrMsg::enroll("Exchange full");
 const WxErrMsg WXM_ENOANO	=WxErrMsg::enroll("No anode");
 const WxErrMsg WXM_EBADRQC	=WxErrMsg::enroll("Invalid request code");
 const WxErrMsg WXM_EBADSLT	=WxErrMsg::enroll("Invalid slot");
 const WxErrMsg WXM_EDEADLOCK	=WXM_EDEADLK;
 const WxErrMsg WXM_E58         =WxErrMsg::enroll("Unknown error 58"); 
 const WxErrMsg WXM_EBFONT	=WxErrMsg::enroll("Bad font file format");
 const WxErrMsg WXM_ENOSTR	=WxErrMsg::enroll("Device not a stream");
 const WxErrMsg WXM_ENODATA	=WxErrMsg::enroll("No data available"); 
 const WxErrMsg WXM_ETIME	=WxErrMsg::enroll("Timer expired");
 const WxErrMsg WXM_ENOSR	=WxErrMsg::enroll("Out of streams resources");
 const WxErrMsg WXM_ENONET	=WxErrMsg::enroll("Machine is not on the network");
 const WxErrMsg WXM_ENOPKG	=WxErrMsg::enroll("Package not installed");
 const WxErrMsg WXM_EREMOTE	=WxErrMsg::enroll("Object is remote");
 const WxErrMsg WXM_ENOLINK	=WxErrMsg::enroll("Link has been severed");
 const WxErrMsg WXM_EADV	=WxErrMsg::enroll("Advertise error");
 const WxErrMsg WXM_ESRMNT	=WxErrMsg::enroll("Srmount error");
 const WxErrMsg WXM_ECOMM	=WxErrMsg::enroll("Communication error on send");
 const WxErrMsg WXM_EPROTO 	=WxErrMsg::enroll("Protocol error");
 const WxErrMsg WXM_EMULTIHOP	=WxErrMsg::enroll("Multihop attempted");
 const WxErrMsg WXM_EDOTDOT	=WxErrMsg::enroll("RFS specific error");
 const WxErrMsg WXM_EBADMSG	=WxErrMsg::enroll("Not a data message");
 const WxErrMsg WXM_EOVERFLOW	=WxErrMsg::enroll("Value too large for defined data type");
 const WxErrMsg WXM_ENOTUNIQ	=WxErrMsg::enroll("Name not unique on network");
 const WxErrMsg WXM_EBADFD	=WxErrMsg::enroll("File descriptor in bad state");
 const WxErrMsg WXM_EREMCHG	=WxErrMsg::enroll("Remote address changed");
 const WxErrMsg WXM_ELIBACC	=WxErrMsg::enroll("Can not access a needed shared library");
 const WxErrMsg WXM_ELIBBAD	=WxErrMsg::enroll("Accessing a corrupted shared library");
 const WxErrMsg WXM_ELIBSCN	=WxErrMsg::enroll(".lib section in a.out corrupted");
 const WxErrMsg WXM_ELIBMAX	=WxErrMsg::enroll("Attempting to link in too many shared libraries");
 const WxErrMsg WXM_ELIBEXEC	=WxErrMsg::enroll("Cannot exec a shared library directly");
 const WxErrMsg WXM_EILSEQ	=WxErrMsg::enroll("Illegal byte sequence"); 
 const WxErrMsg WXM_ERESTART	=WxErrMsg::enroll("Interrupted system call should be restarted");
 const WxErrMsg WXM_ESTRPIPE	=WxErrMsg::enroll("Streams pipe error");
 const WxErrMsg WXM_EUSERS	=WxErrMsg::enroll("Too many users");
 const WxErrMsg WXM_ENOTSOCK	=WxErrMsg::enroll("Socket operation on non-socket");
 const WxErrMsg WXM_EDESTADDRREQ=WxErrMsg::enroll("Destination address required");
 const WxErrMsg WXM_EMSGSIZE	=WxErrMsg::enroll("Message too long");
 const WxErrMsg WXM_EPROTOTYPE	=WxErrMsg::enroll("Protocol wrong type for socket");
 const WxErrMsg WXM_ENOPROTOOPT=WxErrMsg::enroll("Protocol not available");
 const WxErrMsg WXM_EPROTONOSUPPORT=WxErrMsg::enroll("Protocol not supported");
 const WxErrMsg WXM_ESOCKTNOSUPPORT=WxErrMsg::enroll("Socket type not supported");
 const WxErrMsg WXM_EOPNOTSUPP	=WxErrMsg::enroll("Operation not supported on transport endpoint");
 const WxErrMsg WXM_EPFNOSUPPORT=WxErrMsg::enroll("Protocol family not supported");
 const WxErrMsg WXM_EAFNOSUPPORT=WxErrMsg::enroll("Address family not supported by protocol");
 const WxErrMsg WXM_EADDRINUSE	=WxErrMsg::enroll("Address already in use");
 const WxErrMsg WXM_EADDRNOTAVAIL=WxErrMsg::enroll("Cannot assign requested address");
 const WxErrMsg WXM_ENETDOWN	=WxErrMsg::enroll("Network is down");
 const WxErrMsg WXM_ENETUNREACH=WxErrMsg::enroll("Network is unreachable");
 const WxErrMsg WXM_ENETRESET	=WxErrMsg::enroll("Network dropped connection because of reset");
 const WxErrMsg WXM_ECONNABORTED=WxErrMsg::enroll("Software caused connection abort");
 const WxErrMsg WXM_ECONNRESET	=WxErrMsg::enroll("Connection reset by peer");
 const WxErrMsg WXM_ENOBUFS	=WxErrMsg::enroll("No buffer space available"); 
 const WxErrMsg WXM_EISCONN	=WxErrMsg::enroll("Transport endpoint is already connected");
 const WxErrMsg WXM_ENOTCONN	=WxErrMsg::enroll("Transport endpoint is not connected");
 const WxErrMsg WXM_ESHUTDOWN	=WxErrMsg::enroll("Cannot send after transport endpoint shutdown");
 const WxErrMsg WXM_ETOOMANYREFS=WxErrMsg::enroll("Too many references: cannot splice");
 const WxErrMsg WXM_ETIMEDOUT	=WxErrMsg::enroll("Connection timed out");
 const WxErrMsg WXM_ECONNREFUSED=WxErrMsg::enroll("Connection refused");
 const WxErrMsg WXM_EHOSTDOWN	=WxErrMsg::enroll("Host is down"); 
 const WxErrMsg WXM_EHOSTUNREACH=WxErrMsg::enroll("No route to host");
 const WxErrMsg WXM_EALREADY	=WxErrMsg::enroll("Operation already in progress");
 const WxErrMsg WXM_EINPROGRESS=WxErrMsg::enroll("Operation now in progress");
 const WxErrMsg WXM_ESTALE	=WxErrMsg::enroll("Stale NFS file handle");
 const WxErrMsg WXM_EUCLEAN	=WxErrMsg::enroll("Structure needs cleaning");
 const WxErrMsg WXM_ENOTNAM	=WxErrMsg::enroll("Not a XENIX named type file");
 const WxErrMsg WXM_ENAVAIL	=WxErrMsg::enroll("No XENIX semaphores available");
 const WxErrMsg WXM_EISNAM	=WxErrMsg::enroll("Is a named type file"); 
 const WxErrMsg WXM_EREMOTEIO	=WxErrMsg::enroll("Remote I/O error");
 const WxErrMsg WXM_EDQUOT	=WxErrMsg::enroll("Quota exceeded");
 const WxErrMsg WXM_ENOMEDIUM	=WxErrMsg::enroll("No medium found");
 const WxErrMsg WXM_EMEDIUMTYPE =WxErrMsg::enroll("Wrong medium type"); 
 const WxErrMsg WXM_E125        =WxErrMsg::enroll("Operation canceled");
 const WxErrMsg WXM_E126        =WxErrMsg::enroll("Unknown error 126"); 
 const WxErrMsg WXM_E127	=WxErrMsg::enroll("Unknown error 127");

//
// WxLib added global errmsg constants
//
 const WxErrMsg WXM_THRDCAN     =WxErrMsg::enroll("Thread canceled");
 const WxErrMsg WXM_NDEFAULT	=WxErrMsg::enroll("Object not default"); 
 const WxErrMsg WXM_DIVZERO     =WxErrMsg::enroll("Divisor is zero");
 const WxErrMsg WXM_MATHNEG     =WxErrMsg::enroll("Math negation failure");
 const WxErrMsg WXM_VFDIS       =WxErrMsg::enroll("Virtual function disabled");

 //
 // The number of errno's pre-existed in C-libiary is set to MaxErrNo+1.
 //
 // (gcc v2.3 warns the use of sys_nerr, and no other way found to get this
 //  information. Besides, I guess the traditional errno is unlikely to exceed 127, 
 //  so make it constant and hope C-library errno would never really exceed it,
 //  otherwise only the fisrt WxErrMsg::MaxErrNo+1 errno's are setup.)
 //
 const char* const WxErrMsg::wx_errno_tab[WxErrMsg::MaxErrNo+1]={
	 OK._emsg,		   // 0
	 WXM_EPERM._emsg,	   // 1
	 WXM_ENOENT._emsg,	   // 2
	 WXM_ESRCH._emsg,	   // 3
	 WXM_EINTR._emsg,	   // 4
	 WXM_EIO._emsg,		   // 5
	 WXM_ENXIO._emsg,	   // 6
	 WXM_E2BIG._emsg,	   // 7
	 WXM_ENOEXEC._emsg,	   // 8
	 WXM_EBADF._emsg,	   // 9
	 WXM_ECHILD._emsg,	   // 10
	 WXM_EAGAIN._emsg,	   // 11
	 WXM_ENOMEM._emsg,	   // 12
	 WXM_EACCES._emsg,	   // 13
	 WXM_EFAULT._emsg,	   // 14
	 WXM_ENOTBLK._emsg,	   // 15
	 WXM_EBUSY._emsg,	   // 16
	 WXM_EEXIST._emsg,	   // 17
	 WXM_EXDEV._emsg,	   // 18
	 WXM_ENODEV._emsg,	   // 19
	 WXM_ENOTDIR._emsg,	   // 20
	 WXM_EISDIR._emsg,	   // 21
	 WXM_EINVAL._emsg,	   // 22
	 WXM_ENFILE._emsg,	   // 23
	 WXM_EMFILE._emsg,	   // 24
	 WXM_ENOTTY._emsg,	   // 25
	 WXM_ETXTBSY._emsg,	   // 26
	 WXM_EFBIG._emsg,	   // 27
	 WXM_ENOSPC._emsg,	   // 28
	 WXM_ESPIPE._emsg,	   // 29
	 WXM_EROFS._emsg,	   // 30
	 WXM_EMLINK._emsg,	   // 31
	 WXM_EPIPE._emsg,	   // 32
	 WXM_EDOM._emsg,	   // 33
	 WXM_ERANGE._emsg,	   // 34
	 WXM_EDEADLK._emsg,	   // 35
	 WXM_ENAMETOOLONG._emsg,   // 36
	 WXM_ENOLCK._emsg,	   // 37
	 WXM_ENOSYS._emsg,	   // 38
	 WXM_ENOTEMPTY._emsg,	   // 39
	 WXM_ELOOP._emsg,	   // 40
	 WXM_E41._emsg,	           // 41
	 WXM_ENOMSG._emsg,	   // 42
	 WXM_EIDRM._emsg,	   // 43
	 WXM_ECHRNG._emsg,	   // 44
	 WXM_EL2NSYNC._emsg,	   // 45
	 WXM_EL3HLT._emsg,	   // 46
	 WXM_EL3RST._emsg,	   // 47
	 WXM_ELNRNG._emsg,	   // 48
	 WXM_EUNATCH._emsg,	   // 49
	 WXM_ENOCSI._emsg,	   // 50
	 WXM_EL2HLT._emsg,	   // 51
	 WXM_EBADE._emsg,	   // 52
	 WXM_EBADR._emsg,	   // 53
	 WXM_EXFULL._emsg,	   // 54
	 WXM_ENOANO._emsg,	   // 55
	 WXM_EBADRQC._emsg,	   // 56
	 WXM_EBADSLT._emsg,	   // 57
	 WXM_E58._emsg,	           // 58
	 WXM_EBFONT._emsg,	   // 59
	 WXM_ENOSTR._emsg,	   // 60
	 WXM_ENODATA._emsg,	   // 61
	 WXM_ETIME._emsg,	   // 62
	 WXM_ENOSR._emsg,	   // 63
	 WXM_ENONET._emsg,	   // 64
	 WXM_ENOPKG._emsg,	   // 65
	 WXM_EREMOTE._emsg,	   // 66
	 WXM_ENOLINK._emsg,	   // 67
	 WXM_EADV._emsg,	   // 68
	 WXM_ESRMNT._emsg,	   // 69
	 WXM_ECOMM._emsg,	   // 70
	 WXM_EPROTO._emsg,	   // 71
	 WXM_EMULTIHOP._emsg,	   // 72
	 WXM_EDOTDOT._emsg,	   // 73
	 WXM_EBADMSG._emsg,	   // 74
	 WXM_EOVERFLOW._emsg,	   // 75
	 WXM_ENOTUNIQ._emsg,	   // 76
	 WXM_EBADFD._emsg,	   // 77
	 WXM_EREMCHG._emsg,	   // 78
	 WXM_ELIBACC._emsg,	   // 79
	 WXM_ELIBBAD._emsg,	   // 80
	 WXM_ELIBSCN._emsg,	   // 81
	 WXM_ELIBMAX._emsg,	   // 82
	 WXM_ELIBEXEC._emsg,	   // 83
	 WXM_EILSEQ._emsg,	   // 84
	 WXM_ERESTART._emsg,	   // 85
	 WXM_ESTRPIPE._emsg,	   // 86
	 WXM_EUSERS._emsg,	   // 87
	 WXM_ENOTSOCK._emsg,	   // 88
	 WXM_EDESTADDRREQ._emsg,   // 89
	 WXM_EMSGSIZE._emsg,	   // 90
	 WXM_EPROTOTYPE._emsg,	   // 91
	 WXM_ENOPROTOOPT._emsg,	   // 92
	 WXM_EPROTONOSUPPORT._emsg,// 93
	 WXM_ESOCKTNOSUPPORT._emsg,// 94
	 WXM_EOPNOTSUPP._emsg,	   // 95
	 WXM_EPFNOSUPPORT._emsg,   // 96
	 WXM_EAFNOSUPPORT._emsg,   // 97
	 WXM_EADDRINUSE._emsg,	   // 98
	 WXM_EADDRNOTAVAIL._emsg,  // 99
	 WXM_ENETDOWN._emsg,	   // 100
	 WXM_ENETUNREACH._emsg,	   // 101
	 WXM_ENETRESET._emsg,	   // 102
	 WXM_ECONNABORTED._emsg,   // 103
	 WXM_ECONNRESET._emsg,	   // 104
	 WXM_ENOBUFS._emsg,	   // 105
	 WXM_EISCONN._emsg,	   // 106
	 WXM_ENOTCONN._emsg,	   // 107
	 WXM_ESHUTDOWN._emsg,	   // 108
	 WXM_ETOOMANYREFS._emsg,   // 109
	 WXM_ETIMEDOUT._emsg,	   // 110
	 WXM_ECONNREFUSED._emsg,   // 111
	 WXM_EHOSTDOWN._emsg,	   // 112
	 WXM_EHOSTUNREACH._emsg,   // 113
	 WXM_EALREADY._emsg,	   // 114
	 WXM_EINPROGRESS._emsg,	   // 115
	 WXM_ESTALE._emsg,	   // 116
	 WXM_EUCLEAN._emsg,	   // 117
	 WXM_ENOTNAM._emsg,	   // 118
	 WXM_ENAVAIL._emsg,	   // 119
	 WXM_EISNAM._emsg,	   // 120
	 WXM_EREMOTEIO._emsg,	   // 121
	 WXM_EDQUOT._emsg,	   // 122
	 WXM_ENOMEDIUM._emsg,	   // 123
	 WXM_EMEDIUMTYPE._emsg,	   // 124
	 WXM_E125._emsg,           // 125
	 WXM_E126._emsg,           // 126
	 WXM_E127._emsg 	   // 127
        };

void WxErrMsg::_set_emsg(int en) throw(std::exception)
try {
 if((en<0)||(en>WxErrMsg::MaxErrNo)) {
   WX_THROW( Wx_bad_errno(en) );
 }
 _emsg=wx_errno_tab[en];
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW( Wx_general_error() );
};

int WxErrMsg::assign(int en) throw(std::exception)
try {
 if((en<0)||(en>WxErrMsg::MaxErrNo)) {
   return(EINVAL);
 }
 _emsg=wx_errno_tab[en];
 return(0);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW( Wx_general_error() );
};

int WxErrMsg::c_errno(void) const throw(std::exception)
try {
 int idx;
 // tbm+ light binary search
 for(idx=0; idx<=WxErrMsg::MaxErrNo; ++idx) {
   if(_emsg==wx_errno_tab[idx]) {
     return(idx);
   }
 }
 return(-1);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW( Wx_general_error() );
};
//-----------------------------------------------------------------------------
// Definition code for Wx_SrcLoc
//
// Note: Order of code is significant
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definition code for WxErrMsg
//
// Note: Order of code is significant
//-----------------------------------------------------------------------------


//-------------------------------------------------
// Definition for WxRet
//
// Note: Order of code is significant
//-------------------------------------------------

//-------------------------------------------------
// Definition for wxr_except.h
//
// Note: Order of code is significant
//-------------------------------------------------

const char Wx_bad_alloc::class_name[]="Wx_bad_alloc";
const char Wx_except::class_name[]="Wx_except";
const char Wx_general_error::class_name[]="Wx_general_error";
const char Wx_bad_errno::class_name[]="Wx_bad_errno";
