/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   This file should conform to the documentation in file wxregfile.3wx
*/

#ifndef WXREGFILE_H__
#define WXREGFILE_H__
#define WXREGFILE_VERSION 8

#include "wxbytetape.h"

/*
  WxRegFile defines the class for the system regular file.

  [Avoided C Use] lseek, mkstemp

  Note: Some of the error messages are based on Linux Programmer's Manual.
*/
class WxRegFile : public WxByteTape {
  public:
    static const char class_name[];
    WX_DECLARE_FAULT;

    WxRegFile() throw() 
              : WxByteTape() {};

    WxRegFile(const WxRegFile &src) throw(std::exception,WxRet);

    virtual ~WxRegFile() throw(std::exception);

    // [Derived]
    //bool is_default(void) const throw() 

    // [Derived]
    // WxFileHandle fh(void) const throw()

    // [Derived]
    // WxRet fstat(WxFileStat& filestat) const throw(std::exception);

    // [Derived]
    // virtual WxRet reset(void) throw(std::exception);

    // [Derived]
    // virtual WxRet read(void *buf, size_t count, size_t *n_read) throw(std::exception);

    // [Derived]
    // virtual WxRet max_read(void* buf,size_t count,size_t* n_read) throw(std::exception);
    
    // [Derived]
    // virtual WxRet write(const void *buf, size_t count, size_t *n_written) throw(std::exception);

    // [Derived]
    // virtual WxRet drain(void) throw(std::exception)

    // [Derived]
    // off_t get_pos(void) const throw() 
	    
    // [Derived]
    // virtual void set_pos(off_t ofst) throw() 

    // [Derived]
    // virtual WxRet seek_pos_end(void) throw(std::exception);
    
    // [Derived]
    // virtual WxRet read_line(void *buf, size_t count, size_t *n_read) throw(std::exception);

    // [Derived]
    //virtual WxRet read_line(WxStr &buf,size_t* n_read=0) throw(std::exception);

    // [Derived]
    //virtual WxRet resize(off_t length) throw(std::exception)

    virtual WxRet open(const WxPathName& pathname,int f) throw(std::exception);

    virtual WxRet open(const WxPathName& pathname,int f,mode_t m) throw(std::exception);

    virtual WxRet open_tmpfile(WxPathName& name_temp) throw(std::exception);

    virtual WxRet assignf(WxFileHandle fh) throw(std::exception);

    virtual WxRet assignf(const WxRegFile& src) throw(std::exception);

    // [Derived]
    // WxRet wx_set_fh(WxFileHandle fh) throw(std::exception)

  protected:
    //
    // [Syn] Construct object from the open fd
    //
    // Note: This is not a direct copy of fd but a duplicate by dup()
    // Note: r/w position is constructed with default value.
    //
    // [Exception] Wx_general_error
    //             Wx_bad_alloc
    //             Wx_bad_errno
    // 
    // [Exception] Fault
    //       WXM_EINVAL fd is not an open fd
    //       WXM_EBADF  fd is not valid for the operation
    //       WXM_EMFILE too many open fd
    //
    // Note: errmsg is converted from the errno ::dup returned
    //
    // [Refer] ::dup(int)
    //
    WxRegFile(WxFileHandle fh) throw(std::exception,WxRet);

    // [Derived]
    // WxRet wx_open(const WxPathName& pathname,int f) throw(std::exception);

    // [Derived]
    // WxRet wx_open(const WxPathName& pathname,int f,int m) throw(std::exception);

    // [Derived]
    // WxRet wx_open_tmpfile(WxPathName& name_temp) throw(std::exception);

    // [Derived]
    // WxRet wx_assignf(const WxByteTape& src) throw(std::exception);

    // [Derived]
    // WxRet wx_fcntl(int cmd,int *ret_f) const throw(std::exception)

    // [Derived]
    // WxRet wx_fcntl(int cmd, long arg, int *ret_f) const throw(std::exception)

    // [Derived]
    // WxRet wx_fcntl(int cmd, struct flock *lock,int *ret_f) const throw(std::exception)

  private:

    const WxRegFile & operator =(const WxRegFile &); // not to use
    bool operator==(const WxRegFile&) const throw();  // not to use
};

#endif
