/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxregfile.h"

const char WxRegFile::class_name[]="WxRegFile";

WxRegFile::WxRegFile(WxFileHandle fh) throw(std::exception,WxRet)
try : WxByteTape(fh) {
}
catch(const WxByteTape::Fault& e) {
  WX_THROW( Fault(e) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRegFile::WxRegFile(const WxRegFile &src) throw(std::exception,WxRet)
try : WxByteTape(src) {
}
catch(const WxByteTape::Fault& e) {
  WX_THROW( Fault(e) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRegFile::~WxRegFile() throw(std::exception)
try {
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxRegFile::open(const WxPathName& pathname,int f) throw(std::exception)
try {
 WX_RETURN( WxByteTape::wx_open(pathname,f) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxRegFile::open(const WxPathName& pathname,int f,mode_t m) throw(std::exception)
try {
 WX_RETURN( WxByteTape::wx_open(pathname,f,m) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxRegFile::open_tmpfile(WxPathName& tmp_name) throw(std::exception)
try {
 WX_RETURN( WxByteTape::wx_open_tmpfile(tmp_name) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxRegFile::assignf(WxFileHandle fh) throw(std::exception)
try {
  // stat fh
  if(fh.is_default()==false) {
    WxFileStat stt;
    const WxRet r=fh.stat(stt);
    if(r!=OK) {
      WX_RETURN(r);
    } 
    if(stt.is_reg()==false) {
      WX_RETURN(WXM_EBADF);
    }
  }
  WX_RETURN( WxByteTape::wx_assignf(fh) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxRegFile::assignf(const WxRegFile& src) throw(std::exception)
try {
 WX_RETURN( WxByteTape::wx_assignf(src) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};
