/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003-2004)

 This file is part of wxret.h and is included there. 
 Definition code is in wxret.cpp
 */
#ifndef WXR_SRCLOC_H__
#define WXR_SRCLOC_H__
#define WXR_SRCLOC_VERSION 8

//
// [Thread-Safe]
//
// [Internal] Class holding source location information
//
// Instances of this class should mostly be static const declared to live
// throughout program life time.
//
// Note: All member functions do not throw exception
// 
class Wx_SrcLoc {
  public:
    //
    // [Syn] Construct default object
    //
    //       Wx_SrcLoc().src_file() = 0
    //       Wx_SrcLoc().src_line() = 0
    //
    inline Wx_SrcLoc() throw()
	      : _fn(0),_ln(0) {};

    //
    // [Syn] Construct by copy
    //
    inline Wx_SrcLoc(const Wx_SrcLoc& c) throw()
         : _fn(c._fn), _ln(c._ln) {};   // self-copy ok
				
    //
    // [Syn] Construct the object to hold the source location information.
    //
    // Note: The c-string pointed to by file_name is supposed to exist constantly 
    //       throughout the program life time.
    //
    inline Wx_SrcLoc(const char* file_name, int line) throw()
	      : _fn(file_name),_ln(line) {};

    virtual ~Wx_SrcLoc() throw() {};

    //
    // [Syn] Is object default
    //
    // [Ret] true= object is equivalent to Wx_SrcLoc()
    //       false= otherwise
    //
    inline bool is_default(void) const throw() 
              { return (_fn==0)&&(_ln==0); };
 
    //
    // [Syn] Reset object to the constructed state as the parameters indicates
    //   
    // Note: The c-string pointed to by file_name is supposed to exist constantly 
    //       throughout the program life time.
    //
    inline void reset(void) throw()
              { _fn=0; _ln=0; };
    inline void reset(const char* file_name, int line) throw()
              { _fn=file_name; _ln=line; };
    inline void reset(const Wx_SrcLoc& c) throw()
              { _fn=c._fn; _ln=c._ln; };

    //
    // [Syn] Get the file name pointer this object holds
    //
    // [Ret] pointer of the file name this object holds
    //       or zero if object is default
    //
    inline const char *src_file(void) const throw() 
              { return _fn; };

    //
    // [Syn] Get the line number
    //
    // [Ret] The line number this object holds
    //       or zero if object is default
    //
    inline int src_line(void) const throw() 
              { return _ln; };

    //
    // [Syn] Test object equivalence
    //
    // [Ret] true= object contents is equivalent
    //      false= otherwise
    //
    bool operator==(const Wx_SrcLoc& rhs) const throw()
              { return (_fn==rhs._fn)&&(_ln==rhs._ln); };
    bool operator!=(const Wx_SrcLoc& rhs) const throw()
              { return (_fn!=rhs._fn)||(_ln!=rhs._ln); };
  private:
    const char* _fn;
    int _ln;
};

#endif
