/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

 This file is part of wxret.h and is included there. 
 Definition code is in wxret.cpp

 */
#ifndef WXR_RET_H__
#define WXR_RET_H__
#define WXR_RET_VERSION 8

#include <stdexcept>
#include "wxr_errmsg.h"
/*
[Thread-Safe]

 Note: sizeof(WxRet) is limited to the largest size of std exception family 
       to ensure safty. 
       WxRet contains no vtbl because of the above concern.

 Note: All member functions do not throw exception
*/
class WxRet : private WxErrMsg {
    // inherit because WxRet is-a WxErrMsg (WxErrMsg+SLI)
    // private to prevent from using the base class via reference 
  public:
    inline WxRet() throw()
           : WxErrMsg(),_slp(0) {};

    inline WxRet(const WxRet& r) throw() 
           : WxErrMsg(r),_slp(r._slp) {};

    inline WxRet(const WxErrMsg& em) throw()
           : WxErrMsg(em), _slp(0) {};

    // Note: SLI is not the class's property
    inline bool is_default(void) const throw()
           { return WxErrMsg::is_default(); };

    //
    // Note: Different implementations may not inherits from WxErrMsg.
    //       This member provides explicit way to obtain WxErrMsg from
    //       WxRet object.
    // 
    //inline WxErrMsg errmsg(void) const throw()
    //          { return *this; };

    inline void reset(void) throw()
           { WxErrMsg::reset(); _slp=0; };

    inline void reset(const WxErrMsg& em) throw()
           { WxErrMsg::reset(em); _slp=0; };

    inline void reset(const WxRet& r) throw()
           { WxErrMsg::reset(r); _slp=r._slp; };

    inline void assign(const WxErrMsg& em) throw()
           { WxErrMsg::reset(em); _slp=0; };

    inline void assign(const WxRet& r) throw()
           { WxErrMsg::assign(r); _slp=r._slp; };

    inline const WxRet& operator =(const WxErrMsg& em) throw()
           { WxErrMsg::operator =(em); _slp=0; return(*this); };

    inline const WxRet& operator =(const WxRet& r) throw()
           { WxErrMsg::operator =(r); return(*this); };

    // Note: SLI is not the class's property
    inline bool operator ==(const WxRet& r) const throw()
           { return WxErrMsg::operator==(r); }

    // Note: SLI is not the class's property
    inline bool operator !=(const WxRet& r) const throw()
           { return WxErrMsg::operator!=(r); }

    inline int c_errno(void) const throw(std::exception)
              { return WxErrMsg::c_errno(); };

    inline const char* c_errstr(void) const throw()
              { return WxErrMsg::c_errstr(); };

    //
    // Note: SLI is not the class's property
    //
    inline const Wx_SrcLoc* sli_ptr(void) const throw() 
              { return _slp; };

    //
    // Note: SLI is not the class's property
    // Note: The source location object should exist constantly 
    //       throughout the program life time.
    //
    inline const WxRet& set_sli(const Wx_SrcLoc* s) throw()
              { _slp=s; return *this; };
  private:
    const Wx_SrcLoc *_slp;
 
    // 
    // The following functions are derived from WxErrMsg and hidden
    //
    WxRet(int en) throw(std::exception);
    void reset(int) throw(std::exception);
    void assign(int en) throw(std::exception);
    const WxRet& operator =(int) throw(std::exception); 
    static WxErrMsg enroll(const char*);

    friend bool operator ==(const WxErrMsg& em, const WxRet &rhs) throw();
    friend bool operator !=(const WxErrMsg& em, const WxRet &rhs) throw();
    friend bool operator ==(const WxRet &lhs, const WxErrMsg& em) throw();
    friend bool operator !=(const WxRet &lhs, const WxErrMsg& em) throw();
};

// Note: SLI is not the class's property
inline bool operator ==(const WxErrMsg& em, const WxRet &rhs) throw() 
              { return em==static_cast<WxErrMsg>(rhs); };
inline bool operator !=(const WxErrMsg& em, const WxRet &rhs) throw()
              { return em!=static_cast<WxErrMsg>(rhs); };
inline bool operator ==(const WxRet &lhs, const WxErrMsg& em) throw() 
              { return static_cast<WxErrMsg>(lhs)==em; };
inline bool operator !=(const WxRet &lhs, const WxErrMsg& em) throw() 
              { return static_cast<WxErrMsg>(lhs)!=em; };

#endif // WXR_RET_H__
