/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

 This file is part of wxret.h and is included there. 
 Definition code is in wxret.cpp

 Refer to wxret.h, macros are defined to use these exception classes with SLI.

 */
#ifndef WXR_EXCEPT_H__
#define WXR_EXCEPT_H__
#define WXR_EXCEPT_VERSION 8

/*

   Warning: sizeof(Wx_bad_errno) > sizeof(std::logic_error)
            This is not right.

   std::exception -+-> std::bad_alloc ---> Wx_bad_alloc
                   +
                   +-> Wx_except -+-> Wx_general_error
                                  +
                                  +-> Wx_bad_errno
*/

//
// [Thread-Safe]
//
//  Exception for memory allocation error
//
//  Note: Macro functin is defined in wxret.h to throw this exception with SLI.
//
#include <new>
class Wx_bad_alloc : public std::bad_alloc {
  public:
    static const char class_name[];

    Wx_bad_alloc() throw()
      : std::bad_alloc(), _slp(0) {};

    Wx_bad_alloc(const Wx_bad_alloc& e) throw()
      : std::bad_alloc(), _slp(e._slp) {};

    //
    // [Syn] Get the source location object pointer
    //
    // Note: SLI is not the class's property
    //
    // [Ret] pointer of the source location object 
    //       zero if object is default
    //
    const Wx_SrcLoc* sli_ptr(void) const throw() { return _slp; };

    //
    // [Syn] Set the source location to refer to s.
    //
    // Note: SLI is not the class's property
    // Note: The source location object should exist constantly 
    //       throughout the program life time.
    //
    const Wx_bad_alloc& set_sli(const Wx_SrcLoc* s) throw()
              { _slp=s; return(*this); };

    const char* what() const throw()
		{ return class_name; };
  private:
    const Wx_SrcLoc *_slp;
};

//
// [Thread-Safe]
//
// Base exception of most WxLib exceptions, adding source location information.
//
class Wx_except : public std::exception {
  public:
    static const char class_name[];

    Wx_except() throw()
      : std::exception(), _slp(0) {};

    Wx_except(const Wx_except& e) throw()
      : std::exception(), _slp(e._slp) {};

    //
    // [Syn] Get the source location object pointer
    //
    // Note: SLI is not the class's property
    //
    // [Ret] pointer of the source location object 
    //       zero if object is default
    //
    const Wx_SrcLoc* sli_ptr(void) const throw() { return _slp; };

    //
    // [Syn] Set the source location to refer to s.
    //
    // Note: SLI is not the class's property
    // Note: The source location object should exist constantly 
    //       throughout the program life time.
    //
    const Wx_except& set_sli(const Wx_SrcLoc* s) throw()
              { _slp=s; return(*this); };

    const char* what() const throw()
		{ return class_name; };
  private:
    const Wx_SrcLoc *_slp;
};

//
// [Thread-Safe]
//
//  Exception for the function failures that applocation is excepted to terminate
//  without specific reason.
//
//  Note: Macro functin is defined in wxret.h to throw this exception with SLI.
//
class Wx_general_error : public Wx_except {
  public:
    static const char class_name[];

    Wx_general_error() throw()
      : Wx_except() {};

    Wx_general_error(const Wx_general_error& e) throw()
      : Wx_except(e) {};

    //
    // [Syn] Set the source location to refer to s.
    //
    // Note: SLI is not the class's property
    // Note: The source location object should exist constantly 
    //       throughout the program life time.
    //
    const Wx_general_error& set_sli(const Wx_SrcLoc* s) throw()
              { Wx_except::set_sli(s); return(*this); };

    const char* what() const throw()
		{ return class_name; };
};

//
// [Thread-Safe]
// 
//  Exception class for unexcepted errno
//
//  Note: Macro functin is defined in wxret.h to throw this exception with SLI.
//
class Wx_bad_errno : public Wx_except {
  public:
    static const char class_name[];
    Wx_bad_errno() throw()
      : Wx_except(),_en(0) {};

    Wx_bad_errno(const Wx_bad_errno& e) throw()
      : Wx_except(e), _en(e._en) {};

    Wx_bad_errno(int en) throw()
      : Wx_except(), _en(en) {};

    int value(void) const throw() 
      { return(_en); };

    //
    // [Syn] Set the source location to refer to s.
    //
    // Note: SLI is not the class's property
    // Note: The source location object should exist constantly 
    //       throughout the program life time.
    //
    const Wx_bad_errno& set_sli(const Wx_SrcLoc* s) throw()
              { Wx_except::set_sli(s); return(*this); };

    const char* what() const throw()
		{ return class_name; };
  private:
    int _en;
};

#endif
