/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#ifndef WXPATHNAME_H__
#define WXPATHNAME_H__
#define WXPATHNAME_VERSION 8

#include "wxret.h"
#include <sys/stat.h>
#include <sys/types.h>
#include "wxstr.h"

/*
   WxPathName is a class to deal with the pathname

   Existance of this class could be problematic. However,
    1. errors specific to pathname are separated
    2. there may be future use
*/ 
class WxPathName {
  public:
    static const char class_name[];
    WX_DECLARE_FAULT;

    WxPathName() throw()
           : _faddr() {};

    WxPathName(const WxPathName& pathname) throw(std::exception);

    //
    // Note: explicit for caller(I) to know WxPathName is used
    //
    explicit WxPathName(const WxStr& pathname) throw(std::exception,Fault);
    explicit WxPathName(const std::string& pathname) throw(std::exception,Fault);
    explicit WxPathName(const char* pathname) throw(std::exception,Fault);

    ~WxPathName() throw(std::exception)
           { reset(); };

    bool is_default(void) const throw()
           { return _faddr.is_default(); };

    size_t size(void) const throw()
           { return _faddr.size(); };

    void reset(void) throw(std::exception);

    WxStr filename(void) const throw(std::exception);

    WxStr pathname(void) const throw(std::exception)
              { return _faddr; };

    void assign(const WxPathName& pathname) throw(std::exception);
    WxRet assign(const WxStr& pathname) throw(std::exception);
    WxRet assign(const std::string& pathname) throw(std::exception);
    WxRet assign(const char* pathname) throw(std::exception);
    WxRet assign(const char* pathname,size_t len) throw(std::exception);


    const WxPathName& operator =(const WxPathName& rhs) throw(std::exception);
    const WxPathName& operator =(const WxStr& rhs) throw(std::exception,Fault);
    const WxPathName& operator =(const std::string& rhs) throw(std::exception,Fault);
    const WxPathName& operator =(const char* rhs) throw(std::exception,Fault);

    //WxRet push(const std::string& filename) throw(std::exception)
    //void pop(void) throw(std::exception)
    // append_filename

    bool operator ==(const WxPathName& rhs) const throw(std::exception);
    bool operator !=(const WxPathName& rhs) const throw(std::exception)
              { return !operator==(rhs); };
  private:
    static const char Delimiter='/';  // pathname demiliter
    WxRet _chk_pathname(const char*,size_t) const throw(std::exception);
    WxRet _chk_pathname(const char*,size_t*) const throw(std::exception);
    WxRet _assign(const char* pathname,size_t plen) throw(std::exception);

    WxStr _faddr;    // pathname is stored here
};

namespace Wx {
  WxRet unlink(const WxPathName&) throw(std::exception);

  WxRet access(const WxPathName&,int) throw(std::exception);

  WxRet chdir(const WxPathName& path) throw(std::exception);

  WxRet getcwd(WxPathName& path) throw(std::exception);

  WxRet chown(const WxPathName& path,uid_t owner,gid_t group) throw(std::exception);

  WxRet chmod(const WxPathName& path,mode_t mode) throw(std::exception);
};

#endif
