/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   This file should conform to the documentation in file wxlnkfile.3wx
*/

#ifndef WXLNKFILE_H__
#define WXLNKFILE_H__
#define WXLNKFILE_VERSION 8

#include "wxfilestat.h"
#include "wxpathname.h"

/*
  WxLnkFile defines the class for the system link file.

  Note: The implementation open object just by recording the pathname.

  Note: Some of the error messages are based on Linux Programmer's Manual.
*/
class WxLnkFile {
  public:
    static const char class_name[];
    WX_DECLARE_FAULT;

    WxLnkFile() throw() 
              : _pname() {};

    WxLnkFile(const WxLnkFile &src) throw(std::exception,WxRet);

    virtual ~WxLnkFile() throw(std::exception);

    bool is_default(void) const throw()
              { return _pname.pathname().is_default(); };

    WxRet stat(WxFileStat& filestat) const throw(std::exception);

    virtual WxRet reset(void) throw(std::exception);

    virtual WxRet read(WxPathName& value) throw(std::exception);

    virtual WxRet open(const WxPathName& pathname) throw(std::exception);

    virtual WxRet assignf(const WxLnkFile& src) throw(std::exception);

    static WxRet create(const WxPathName& oldpath,const WxPathName& newpath) throw(std::exception);
  private:
    WxPathName _pname;

    const WxLnkFile & operator =(const WxLnkFile &); // not to use
    bool operator==(const WxLnkFile&) const throw();  // not to use
    WxRet close(void); // not to use, see Wx__Handle::close(), yet to define
};

#endif
