/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxlnkfile.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

const char WxLnkFile::class_name[]="WxLnkFile";

WxLnkFile::WxLnkFile(const WxLnkFile &src) throw(std::exception,WxRet)
try : _pname(src._pname) {
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxLnkFile::~WxLnkFile() throw(std::exception)
try {
  _pname.reset();
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxLnkFile::stat(WxFileStat& filestat) const throw(std::exception)
try {
 if(_pname.is_default()) {
   WX_RETURN(WXM_EBADF);
 }
 //
 // Assert that ::lstat failure should not modify the argument
 //
 if(::lstat(_pname.pathname().c_str(),filestat.wx_stt())==0) {
   return(OK);
 }
 WX_RETURN(WxErrMsg(errno));
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxLnkFile::reset(void) throw(std::exception)
try {
  _pname.reset();
  return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxLnkFile::read(WxPathName& value) throw(std::exception)
try {
  if(_pname.is_default()) {
    WX_RETURN(WXM_EBADF);
  }
  char buf[_POSIX_PATH_MAX+1];   // not sure this is right
  const int v=::readlink(_pname.pathname().c_str(),buf,sizeof(buf));
  if(v<0) {
    WX_RETURN(WxErrMsg(v));
  }
  if(v>=int(sizeof(buf))) {
    WX_THROW(Wx_general_error());
  }
  const WxRet r=value.assign(buf,v);
  if(r!=OK) {
    WX_RETURN(r);
  }
  return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxLnkFile::open(const WxPathName& pathname) throw(std::exception)
try {
  if(_pname.is_default()==false) {
    WX_RETURN(WXM_NDEFAULT);
  }
  struct stat stt;
  if(::lstat(pathname.pathname().c_str(),&stt)!=0) {
    WX_RETURN(WxErrMsg(errno));
  }
  if(S_ISLNK(stt.st_mode)==false) {
    WX_RETURN(WXM_ENODEV);
  }
  _pname=pathname;
  return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxLnkFile::assignf(const WxLnkFile& lnkf) throw(std::exception)
try {
  if(_pname.is_default()==false) {
    WX_RETURN(WXM_NDEFAULT);
  }
  _pname=lnkf._pname;
  return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxLnkFile::create(const WxPathName& oldpath,const WxPathName& newpath) throw(std::exception)
try {
  if(::symlink(oldpath.pathname().c_str(),newpath.pathname().c_str())!=0) {
    WX_RETURN(WxErrMsg(errno));
  }
  return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

