/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#ifndef WXICONV_H__
#define WXICONV_H__
#define WXICONV_VERSION 8

#include "wxret.h"
#include <iconv.h>

/*
  WxIConv is a class for the conversion of (multi)byte sequences.

  This class is NO MORE MAINTAINED

  Refer to Linux Programmer's Manual, iconv(3)

  Note: This class is not fully defined

  Note: Some of the error messages are based on Linux Programmer's Manual.
*/
class WxIConv {
  public:
    WX_DECLARE_FAULT;  // declaraion of Fault

    //
    // [Syn] Construct object to convert the byte sequence from fromcode to tocode.
    //       The object is created in its initial conversion state. Conversion 
    //       operations will modify the state.
    //
    // Note: The object is stateful
    //
    // Note: This class is implemented on GNU C, type command "iconv --list"
    //       to show all supported combinations of the tocode/fromcode.
    //
    // [Exception] Wx_bad_errno
    //             Wx_general_error
    //             Wx_bad_alloc
    //
    // [Exception] Fault
    //       WXM_EINVAL conversion from fromcode to tocode is not supported yet.
    //       ... errmsg converted from the errno ::iconv_open returned.
    //
    // [Refer] ::iconv_open
    //
    WxIConv(const char* tocode, const char* fromcode) throw(std::exception,WxRet);

    //
    // [Syn] Destroy object
    //
    virtual ~WxIConv() throw(std::exception,WxRet);
    
    //
    // [Syn] Reset the conversion to the initial state.
    //
    // [Exception] Wx_bad_errno
    //             Wx_general_error
    //             Wx_bad_alloc
    //
    // [Ret] OK    
    //       ...  refer to Linux Programmer's Manual for details.
    //
    WxRet reset_state(void) throw(std::exception);

    //
    // [Syn] Convert multibyte sequence pointed by *inbuf to multibyte sequence
    //       pointed by *outbuf.
    //
    // [Exception] Wx_bad_errno
    //             Wx_general_error
    //             Wx_bad_alloc
    //
    // [Ret] OK     refer to Linux Programmer's Manual for details.
    //       WXM_E2BIG  not enough room of the output buffer
    //       WXM_EILSEQ invalid multibyte sequence encountered
    //       WXM_EINVAL incomplete multibyte sequence encountered
    //       WxErrMsg(errno) other reasons not documented
    //
    // [Refer] iconv(3)
    //
    WxRet iconv(char** inbuf ,size_t* inbytesleft, 
                char** outbuf, size_t* outbytesleft) throw(std::exception);
  private:
    static const ::iconv_t DefaultFd;
    ::iconv_t _fd;
    size_t _rb;     // number of characters converted in a reversible way
                    // in call to ::iconv.

    WxIConv() throw();  // not to use yet
    WxIConv(const WxIConv&) throw();  // not to use yet
    bool operator==(const WxIConv&) const;  // not to use
};

#endif
