/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxiconv.h"

const ::iconv_t WxIConv::DefaultFd=(::iconv_t)(-1);  // must be -1, see man.

WxIConv::WxIConv(const char* tocode, const char* fromcode) throw(std::exception,WxRet)
try : _fd(DefaultFd)
{
 const ::iconv_t v=::iconv_open(tocode,fromcode);
 if(v==(::iconv_t)(-1)) {
   WX_THROW( Fault(WxErrMsg(errno)) );
 }
 _fd=v;
}
catch(const WxIConv::Fault&) {
  throw;
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxIConv::~WxIConv() throw(std::exception,WxRet)
try {
 if(_fd!=DefaultFd) {
   ::iconv_close(_fd); _fd=DefaultFd;
 }
}
catch(const WxIConv::Fault&) {
  throw;
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxIConv::reset_state(void) throw(std::exception)
try {
 const size_t v=::iconv(_fd,NULL,0,NULL,0);
 if(v==(size_t)(-1)) {
   WX_RETURN(WxErrMsg(errno));
 }
 return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxIConv::iconv(char** inbuf ,size_t* inbytesleft, 
                 char** outbuf, size_t* outbytesleft) throw(std::exception)
try {
 const size_t v=::iconv(_fd,inbuf,inbytesleft,outbuf,outbytesleft); 
 if(v==(size_t)(-1)) {
   WX_RETURN(WxErrMsg(errno));
 }
 _rb=v;
 return(OK);
}
catch(const WxIConv::Fault&) {
  throw;
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};
