/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#ifndef WXFILESTAT_H__
#define WXFILESTAT_H__
#define WXFILESTAT_VERSION 8

#include "wxtime.h"
#include <sys/types.h>
#include <sys/stat.h>

/*
   WxFileStat is a class wrapper of "C" struct stat

  [Avoided C Use] struct ::stat
*/
class WxFileStat {
    //
    // [Internal]
    //
    class TIME_T : public WxTime {
      public:
         inline TIME_T(time_t t) throw()
                  : WxTime(t) {};
    };
  public:
    static const char class_name[];

    WxFileStat() throw()
              { ::memset(&_stt,0,sizeof(_stt)); };

    WxFileStat(const WxFileStat &src) throw();

    ~WxFileStat() throw()
              {};

    bool is_default(void) const throw();

    void reset(void) throw()
              { ::memset(&_stt,0,sizeof(_stt)); };

    void assign(const WxFileStat& src) throw()
              {
               if(&src==this) {
                 return;
               }
               _stt=src._stt;
              };

    const WxFileStat& operator =(const WxFileStat &rhs) throw()
              { assign(rhs); return(*this); };

    mode_t mode(void) const throw()
              { return _stt.st_mode; };

    ino_t ino(void) const throw()
              { return _stt.st_ino; };

    dev_t dev(void) const throw()
              { return _stt.st_dev; };

    nlink_t nlink(void) const throw()
              { return _stt.st_nlink; };

    uid_t uid(void) const throw()
              { return _stt.st_uid; };

    gid_t gid(void) const throw()
              { return _stt.st_gid; };

    off_t size(void) const throw()
              { return _stt.st_size; };

    WxTime atime(void) const throw()
              { return TIME_T(_stt.st_atime); };

    WxTime ctime(void) const throw()
              { return TIME_T(_stt.st_ctime); };

    WxTime mtime(void) const throw()
              { return TIME_T(_stt.st_mtime); };

    bool is_dir(void) const throw()
              { return S_ISDIR(_stt.st_mode); };

    bool is_chr(void) const throw()
              { return S_ISCHR(_stt.st_mode); };

    bool is_blk(void) const throw()
              { return S_ISBLK(_stt.st_mode); };

    bool is_reg(void) const throw()
              { return S_ISREG(_stt.st_mode); };

    bool is_fifo(void) const throw()
              { return S_ISFIFO(_stt.st_mode); };

    bool is_lnk(void) const throw()
              { return S_ISLNK(_stt.st_mode); };

    bool is_sock(void) const throw()
              { return S_ISSOCK(_stt.st_mode); };

    bool operator ==(const WxFileStat& rhs) const throw(std::exception);
    bool operator !=(const WxFileStat& rhs) const throw(std::exception)
              { return !operator==(rhs); };

    //
    // [Internal] Get const reference of struct stat
    //
    inline const struct stat* wx_const_stt(void) const throw() 
              { return &_stt; };

    //
    // [Internal] Get reference of struct stat
    //
    inline struct stat* wx_stt(void) throw() 
              { return &_stt; };
  private:
    struct stat _stt;
};

#endif
