/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxfilestat.h"
#include <unistd.h>
#include <memory>

const char WxFileStat::class_name[]="WxFileStat";

WxFileStat::WxFileStat(const WxFileStat& src) throw()
{
 if(&src==this) {
   WX_ABORT();    // looking for trouble
 }
 _stt=src._stt;
 return;
};

bool WxFileStat::is_default() const throw()
{
 static const WxFileStat default_obj;
 return std::memcmp(&_stt,&default_obj._stt,sizeof(_stt))==0;
};

bool WxFileStat::operator ==(const WxFileStat& rhs) const throw(std::exception)
try {
 /*
    Other fields documented on Linux Programmer's Guide are not tesed for equivalence
      dev_t     st_rdev
      blksize_t st_blksize
      blkcnt_t st_blocks
 */
 if((_stt.st_mode==rhs._stt.st_mode)&&
    (_stt.st_ino==rhs._stt.st_ino)&&
    (_stt.st_dev==rhs._stt.st_dev)&&
    (_stt.st_nlink==rhs._stt.st_nlink)&&
    (_stt.st_uid==rhs._stt.st_uid)&&
    (_stt.st_gid==rhs._stt.st_gid)&&
    (_stt.st_size==rhs._stt.st_size)&&
    //(_stt.st_rdev==rhs._stt.st_rdev)&&
    //(_stt.st_blksize==rhs._stt.st_blksize)&&
    //(_stt.st_blocks==rhs._stt.st_blocks)&&
    (_stt.st_atime==rhs._stt.st_atime)&&
    (_stt.st_ctime==rhs._stt.st_ctime)&&
    (_stt.st_mtime==rhs._stt.st_mtime)) {
   return(true);
 }
 return(false);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};
