/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#ifndef WXFILEHANDLE_H__
#define WXFILEHANDLE_H__
#define WXFILEHANDLE_VERSION 8

#include "wxfilestat.h"

/*
   WxFileHandle is a class for file descriptor (file handle)
*/
class WxFileHandle {
  public:
    static const char class_name[];

    WxFileHandle() throw() 
              : _fd(WX__DEFAULT_FD) {};

    //
    // Note: Wx__TypeFD is type int
    //
    WxFileHandle(Wx__TypeFD fd) throw()
              { _fd=fd; }

    WxFileHandle(const WxFileHandle &src) throw()
              { _fd=src._fd; }  // self copy ok

    bool is_default(void) const throw()
              { return _fd==WX__DEFAULT_FD; };

    Wx__TypeFD fd(void) const throw()
        { return _fd; };

    WxRet stat(WxFileStat& filestat) const throw(std::exception);

    void reset(void) throw()
              { _fd=WX__DEFAULT_FD; };

    void assign(const WxFileHandle& src) throw()
        { _fd=src._fd; };

    void assign(Wx__TypeFD fd) throw()
        { _fd=fd; };

    const WxFileHandle& operator =(const WxFileHandle& src) throw()
        { _fd=src._fd; return(*this); };

    const WxFileHandle& operator =(Wx__TypeFD fd) throw()
        { _fd=fd; return(*this); };

    bool operator==(const WxFileHandle& rhs) const throw()
        { return _fd==rhs._fd; };
    bool operator!=(const WxFileHandle& rhs) const throw()
        { return _fd!=rhs._fd; };

  private:
    Wx__TypeFD _fd;
};

namespace Wx {
 extern const WxFileHandle stdin;
 extern const WxFileHandle stdout;
 extern const WxFileHandle stderr;
};

#endif
