
#include "wxfilehandle.h"

namespace Wx {
const WxFileHandle stdin(STDIN_FILENO);
const WxFileHandle stdout(STDOUT_FILENO);
const WxFileHandle stderr(STDERR_FILENO);
};

WxRet WxFileHandle::stat(WxFileStat& filestat) const throw(std::exception)
try {
 //
 // Assert that ::fstat failure should not modify buf.
 //
 if(::fstat(_fd,filestat.wx_stt())==0) {
   return(OK);
 }
 WX_RETURN(WxErrMsg(errno));
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

