/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   This file should conform to the documentation in file wxfifofile.3wx
*/

#ifndef WXFIFOFILE_H__
#define WXFIFOFILE_H__
#define WXFIFOFILE_VERSION 8

#include "wxbyteflow.h"

/*
  Note: Some of the error messages are based on Linux Programmer's Manual.

  [Avoided C Use] mkfifo,pipe
*/
class WxFifoFile : public WxByteFlow {
  public:
    static const char class_name[];
    WX_DECLARE_FAULT;

    WxFifoFile() throw() 
              : WxByteFlow() {};

    WxFifoFile(const WxFifoFile &src) throw(std::exception,WxRet);

    virtual ~WxFifoFile() throw(std::exception);

    // [Derived]
    // bool is_default(void) const throw()

    // [Derived]
    // WxFileHandle fh(void) const throw()

    // [Derived]
    // WxRet stat(WxFileStat& filestat) const throw(std::exception)

    // [Derived]
    //virtual WxRet reset(void) throw(std::exception)
    //          { return WxByteFlow::reset(); };

    // [Derived]
    // virtual WxRet read(void *buf, size_t count, size_t *n_read) throw(std::exception)

    // [Derived]
    // virtual WxRet max_read(void* buf,size_t count,size_t* n_read) throw(std::exception)

    // [Derived]/
    // virtual WxRet write(const void *buf, size_t count, size_t *n_written) throw(std::exception)

    virtual WxRet drain(void) throw(std::exception);

    virtual WxRet open(const WxPathName& pathname,int f) throw(std::exception);

    virtual WxRet assignf(WxFileHandle fh) throw(std::exception);

    virtual WxRet assignf(const WxFifoFile& src) throw(std::exception);

    static WxRet mkpipe(WxFifoFile& rd,WxFifoFile& wr) throw(std::exception);

    static WxRet create(const WxPathName& pathname,mode_t m) throw(std::exception);

    // [Derived]
    // WxRet wx_set_fh(WxFileHandle fh) throw(std::exception)

  protected:
    //
    // [Internal] Construct object from the open fd
    //
    // Note: This is not a direct copy of fd but a duplicate by dup()
    //
    // [Exception] Wx_general_error
    //             Wx_bad_alloc
    //             Wx_bad_errno
    // 
    // [Exception] Fault
    //       WXM_EINVAL fd is not an open fd
    //       WXM_EBADF  fd is not valid for the operation
    //       WXM_EMFILE too many open fd
    //
    // Note: errmsg is converted from the errno ::dup returned
    //
    // [Refer] ::dup(int)
    //
    WxFifoFile(WxFileHandle fh) throw(std::exception,WxRet);

    // [Derived]
    // WxRet wx_open(const WxPathName& pathname,int f) throw(std::exception)
    // WxRet wx_open(const WxPathName& pathname, int f, mode_t m) throw(std::exception)
    // WxRet wx_assignf(const WxByteFlow& byteflow) throw(std::exception)
    // WxRet wx_fcntl(int cmd,int *ret_f) const throw(std::exception)

    // WxRet wx_fcntl(int cmd, long arg, int *ret_f) const throw(std::exception)
    //          { return WxByteFlow::fcntl(cmd,arg,ret_f); }; 

    // WxRet wx_fcntl(int cmd, struct flock *lock,int *ret_f) const throw(std::exception)
    //          { return WxByteFlow::fcntl(cmd,lock,ret_f); };

  private:
    const WxFifoFile & operator =(const WxFifoFile &); // not to use
    bool operator==(const WxFifoFile&) const throw();  // not to use
    WxRet close(void); // not to use, see Wx__Handle::close(), yet to define
};

#endif
