/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxfifofile.h"
#include <sys/types.h>
#include <sys/stat.h>

const char WxFifoFile::class_name[]="WxFifoFile";

WxFifoFile::WxFifoFile(WxFileHandle fh) throw(std::exception,WxRet)
try : WxByteFlow(fh) {
}
catch(const WxByteFlow::Fault& e) {
  WX_THROW( Fault(e) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxFifoFile::WxFifoFile(const WxFifoFile &src) throw(std::exception,WxRet)
try : WxByteFlow(src) {
}
catch(const WxByteFlow::Fault& e) {
  WX_THROW( Fault(e) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxFifoFile::~WxFifoFile() throw(std::exception)
try {
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxFifoFile::drain(void) throw(std::exception)
try {
  WX_RETURN( WxByteFlow::drain() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxFifoFile::open(const WxPathName& pathname,int f) throw(std::exception)
try {
  if(f&O_CREAT) {
    WX_RETURN(WXM_EINVAL);
  }
  WX_RETURN( WxByteFlow::wx_open(pathname,f) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxFifoFile::assignf(WxFileHandle fh) throw(std::exception)
try {
  // stat fh
  if(fh.is_default()==false) {
    WxFileStat stt;
    const WxRet r=fh.stat(stt);
    if(r!=OK) {
      WX_RETURN(r);
    } 
    if(stt.is_fifo()==false) {
      WX_RETURN(WXM_EBADF);
    }
  }
 WX_RETURN( WxByteFlow::wx_assignf(fh) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxFifoFile::assignf(const WxFifoFile& src) throw(std::exception)
try {
  WX_RETURN( WxByteFlow::wx_assignf(static_cast<const WxByteFlow&>(src)) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxFifoFile::mkpipe(WxFifoFile& rd,WxFifoFile& wr) throw(std::exception)
try {
  if(rd.is_default()==false) {
    WX_RETURN(WXM_NDEFAULT);
  }
  if(wr.is_default()==false) {
    WX_RETURN(WXM_NDEFAULT);
  }

  int fds[2];
  if(::pipe(fds)!=0) {
    WX_RETURN(WxErrMsg(errno));
  }
  try {
    WxFileHandle fh;
    WxRet r;

    fh.assign(fds[0]);
    r=rd.wx_set_fh(fh);
    if(r!=OK) {
      WX_RETURN(r);
    }

    fh.assign(fds[1]);
    r=wr.wx_set_fh(fh);
    if(r!=OK) {
      WX_RETURN(r);
    }
  }
  catch(...) {
    if(rd.is_default()) {
      ::close(fds[0]);
    } else {
      rd.reset();
    }
    if(wr.is_default()) {
      ::close(fds[1]);
    } else {
      wr.reset();
    }
    throw;
  }
  return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxFifoFile::create(const WxPathName& pathname,mode_t m) throw(std::exception)
try {
  if(::mkfifo(pathname.pathname().c_str(),m)!=0) {
    WX_RETURN(WxErrMsg(errno));
  }
  return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

