/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   This file should conform to the documentation in file wxdirfile.3wx
*/

#ifndef WXDIRFILE_H__
#define WXDIRFILE_H__
#define WXDIRFILE_VERSION 8

#include "wxpathname.h"
#include "wxfilestat.h"
#include "wxdirent.h"

class Wx__DirHandle;
/*
  WxDirFile defines the class for the system directory file.

  [Avoided C Use] opendir, closedir, rewinddir, readdir_r
*/
class WxDirFile {
  public:
    static const char class_name[];
    WX_DECLARE_FAULT;  // declaraion of Fault

    //
    // Note: default object is defined by zero pointer
    //
    WxDirFile() throw()
              : _hptr(0) {};

    WxDirFile(const WxDirFile &src) throw(std::exception,WxRet);

    virtual ~WxDirFile() throw(std::exception);

    bool is_default(void) const throw()
              { return _hptr==0; };

    WxRet stat(WxFileStat& filestat) const throw(std::exception);

    virtual WxRet reset(void) throw(std::exception);

    virtual WxRet read(WxDirEnt& dirent) throw(std::exception);

    virtual WxRet rewind(void) throw(std::exception);

    virtual WxRet open(const WxPathName& dirname) throw(std::exception);

    virtual WxRet assignf(const WxDirFile& src) throw(std::exception);

    //
    // [Internal] Get the reference count
    //
    // [Ret] reference count of this object
    //       zero if object is default
    //
    size_t wx_ref_count(void) const throw(std::exception);

    static WxRet create(const WxPathName& pathname,mode_t mode) throw(std::exception);

    static WxRet unlink(const WxPathName& pathname) throw(std::exception);
  private:
    Wx__DirHandle *_hptr;
   
    const WxDirFile & operator =(const WxDirFile &); // not to use
    bool operator==(const WxDirFile&) const throw();  // not to use
    WxRet close(void); // not to use
};

#endif
