/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxdirfile.h"
#include "wx__dirhandle.h"

const char WxDirFile::class_name[]="WxDirFile";

WxDirFile::WxDirFile(const WxDirFile &src) throw(std::exception,WxRet)
try {
 if(&src==this) {
   WX_THROW(Wx_general_error());
 }
 _hptr=0;
 if(src.is_default()) {
   return;
 }
 _hptr= new Wx__DirHandle(*src._hptr);
}
catch(const Wx__DirHandle::Fault& e) {
  WX_THROW( WxDirFile::Fault(e) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxDirFile::~WxDirFile() throw(std::exception)
try {
  if(_hptr!=0) {
    delete _hptr; _hptr=0;
  }
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDirFile::stat(WxFileStat& filestat) const throw(std::exception)
try {
  if(_hptr==0) {
    WX_RETURN(WXM_EBADF);
  }
  WX_RETURN( _hptr->fstat(filestat) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDirFile::reset(void) throw(std::exception)
try {
  if(_hptr==0) {
    return(OK);
  }
  const WxRet r=_hptr->reset();
  delete _hptr; _hptr=0;
  WX_RETURN(r);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDirFile::read(WxDirEnt& dent) throw(std::exception)
try {
  if(_hptr==0) {
    WX_RETURN(WXM_EBADF);
  }
  WX_RETURN( _hptr->read(dent) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDirFile::rewind(void) throw(std::exception)
try {
  if(_hptr==0) {
    WX_RETURN(WXM_EBADF);
  }
  WX_RETURN( _hptr->rewind() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDirFile::open(const WxPathName& pathname) throw(std::exception)
try {
  if(_hptr!=0) {
    WX_RETURN(WXM_NDEFAULT);
  }
  WxRet r;
  _hptr= new Wx__DirHandle();
  try {
    r=_hptr->open(pathname);
    if(r!=OK) {
      delete _hptr; _hptr=0;
    }
  }
  catch(...) {
    delete _hptr; _hptr=0;
    throw;
  }
  WX_RETURN(r);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDirFile::assignf(const WxDirFile& src) throw(std::exception)
try {
  if(_hptr!=0) {
    WX_RETURN(WXM_NDEFAULT);
  }
  if(src.is_default()) {
    return(OK);
  }
  WxRet r;
  _hptr= new Wx__DirHandle();
  try {
    r=_hptr->assignf(*src._hptr);
    if(r!=OK) {
      delete _hptr; _hptr=0;
    }
  }
  catch(...) {
    delete _hptr; _hptr=0;
    throw;
  }
  WX_RETURN(r);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

size_t WxDirFile::wx_ref_count(void) const throw(std::exception)
try {
  if(_hptr==0) {
    return(0);
  }
  const size_t v=_hptr->ref_count();
  if(v<=0) {
    WX_THROW(Wx_general_error());
  }
  return(v);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDirFile::create(const WxPathName& pathname,mode_t mode) throw(std::exception)
try {
 if(::mkdir(pathname.pathname().c_str(),mode)!=0) {
   WX_RETURN(WxErrMsg(errno));
 };
 return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDirFile::unlink(const WxPathName& pathname) throw(std::exception)
try {
 if(::rmdir(pathname.pathname().c_str())!=0) {
   WX_RETURN(WxErrMsg(errno));
 };
 return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};
