/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#ifndef WXDIRENT_H__
#define WXDIRENT_H__
#define WXDIRENT_VERSION 8

#include "wxret.h"
#include <sys/types.h>
#include <dirent.h>
#include "wxstr.h"

class Wx__DirHandle;

/*
   WxDirEnt defines the data item that WxDirFile reads.

  [Avoided C Use] struct dirent
*/
class WxDirEnt {
  public:
    static const char class_name[];

    WxDirEnt() throw()
              { std::memset(&_ent,0,sizeof(_ent)); };

    WxDirEnt(const WxDirEnt &src) throw(std::exception);

    ~WxDirEnt() throw()
              {};

    bool is_default(void) const throw();

    void reset(void) throw()
              { std::memset(&_ent,0,sizeof(_ent)); };

    WxStr filename(void) const throw(std::exception);
    
    void assign(const WxDirEnt &src) throw()
              {
               if(&src==this) {
                  return;
               }
               _ent=src._ent;
              };

    const WxDirEnt& operator =(const WxDirEnt &rhs) throw()
              { assign(rhs); return(*this); };

    bool operator ==(const WxDirEnt& rhs) const throw(std::exception);
    bool operator !=(const WxDirEnt& rhs) const throw(std::exception)
              { return !operator==(rhs); };

    //
    // [Internal] Get ::dirent pointer of this object
    //
    struct ::dirent* wx_dent_ptr(void) throw()
              { return &_ent; };
  private:
    struct ::dirent _ent;

    friend class Wx__DirHandle;  // Wx__DirHandle::read access members directly
};

#endif
