/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxdirent.h"

const char WxDirEnt::class_name[]="WxDirEnt";

WxDirEnt::WxDirEnt(const WxDirEnt& src) throw(std::exception)
try {
 if(&src==this) {
   WX_THROW(Wx_general_error());
 }
 _ent=src._ent;
 return;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

bool WxDirEnt::is_default() const throw()
{
 static const WxDirEnt default_obj;
 return std::memcmp(&_ent,&default_obj._ent,sizeof(_ent))==0;
};

WxStr WxDirEnt::filename(void) const throw(std::exception)
try {
 return WxStr(_ent.d_name);  // relies on default d_name=="";
}
catch(const WxStr::Fault& e) {
 WX_THROW( Wx_general_error() );
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

bool WxDirEnt::operator ==(const WxDirEnt& rhs) const throw(std::exception)
try {
 /*
    Other fields documented on Linux Programmer's Guide are not tesed for equivalence
    long  d_ino
    off_t off
    ushort d_reclen
 */
 return std::strcmp(_ent.d_name,rhs._ent.d_name)==0;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};
