/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   WxDefs defines symbols/types/macros for WxLib classes.
*/
#ifndef WXDEFS_H__
#define WXDEFS_H__

#include <cerrno>
#include <unistd.h>

#ifndef WXLIB_DISABLE_POSIX_SOURCE
 #if _POSIX_VERSION<199506L
 #error No Support For POSIX1003.1c     // thread support is required
 #endif

 #ifndef _POSIX_VERSION
 #error No POSIX Support
 #endif

 #ifndef _POSIX_SOURCE
 #define _POSIX_SOURCE
 #endif

 #ifndef _POSIX_C_SOURCE
 #define _POSIX_C_SOURCE 199309
 #endif
#endif

#ifndef uchar
typedef unsigned char uchar;     //  8 bits
#endif

#ifndef uint
typedef unsigned int  uint;      // what the hell
#endif

#ifndef ushort
typedef unsigned short ushort;   // 16 bits
#endif

#ifndef ulong
typedef unsigned long int ulong;     // 32 bits
#endif

#ifndef ulong
typedef unsigned long long int ullong;     // 64 bits
#endif

//
// Wxlib version number
//
#define WXLIB_VERSION 8
#define WXLIB_VERSION_TIME    0x20031116U

// 
// Object signature of WxLib is defined here.
// Object that concerns being accessed after destroyed should have an signature.
//
// The format of ID=0x0RSTRST0, where 'R' 'S' 'T' is a hexidecimal digit 0-f.
//
const long WX_NONE_ID=0x1289abcd;     //  Not an WxLib ID number
const long WXMUTEX_ID=0x08208200;     //  for WxMutex object
const long WXCOND_ID =0x08308300;     //  for WxCond object

#include "wx__base.h"

//
// Abort with expressions 
//
// fix: This macro is subject to change. (bad_alloc)
//
// [Exception] None
//
#include <iostream>
#define WX_ABORT(expr) std::cerr << "Abort: "#expr << ' ' << __FILE__\
                                 << '(' << __LINE__ << ")\n"; Wx__Base::abort()

const char WXSTR_UNKEXCPT[]="WxLib: unexpected";

typedef int Wx__TypeFD;             // file descriptor type
const Wx__TypeFD WX__DEFAULT_FD=-1; // default file descriptor

#define WX_CONST_GIGA 1000000000    // 1x10^9

#endif
