/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxdate.h"
#include "wxnum.h"

// 
// For mktime, localtime_r
// 
#include <time.h>    
#include <ctime>

class WxDate__static_check__ {
  public:
    WxDate__static_check__ () 
              {
               // WxDate assertions
               if(WxTime()!=WxTime(0,0)) {
                 WX_ABORT();
               }
              };
} static wx_do_not_use_me__;

const char WxDate::class_name[]="WxDate";

WxDate::WxDate(const WxTime &tt) throw(std::exception,Fault)
try {
 WxRet r=assign(tt);
 if(r!=OK) {
   WX_THROW( Fault(r) );
 }
}
catch(const WxDate::Fault&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxDate::WxDate(int year,int month,int mday, int hour,int min, int sec) throw(std::exception,Fault)
try {
 WxRet r=assign(year,month,mday,hour,min,sec);
 if(r!=OK) {
   WX_THROW( Fault(r) );
 }
}
catch(const WxDate::Fault&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxRet WxDate::reset(void) throw(std::exception)
try {
 _year=1970;
 _month=1;
 _mday=1;
 _hour=0;
 _min=0;
 _sec=0;
 _wday=4;
 _yday=0;
 _wxt.reset();
 return(OK);
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDate::assign(const WxTime &rhs) throw(std::exception)
try {
struct tm tm;

 {
   std::time_t tt;
   if(WxTime::wx__secs2time_t(rhs.secs(),tt)!=0) {
     WX_RETURN(WXM_ERANGE);          // type conversion failed
   }
   if(::localtime_r(&tt,&tm)==NULL) {
     WX_RETURN(WXM_ERANGE);
   }
 }

 _year=tm.tm_year+1900;
 _month=tm.tm_mon+1;
 _mday=tm.tm_mday;
 _hour=tm.tm_hour;
 _min=tm.tm_min;
 _sec=tm.tm_sec;
 _wday=tm.tm_wday;
 _yday=tm.tm_yday;
 _wxt.assign(rhs.secs(),0);       // nano second ignored (set to zero)
 return(OK);
}
catch(const std::bad_alloc&) {
 WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxDate::assign(int year,int month,int mday,
		     int hour,int min,int sec) throw(std::exception)
try {
  if((month<1)||(mday<1)||(hour<0)||(min<0)||(sec<0)) {
    WX_RETURN(WXM_EINVAL);
  }
  struct std::tm tm;
  tm.tm_year=year-1900;
  tm.tm_mon=month-1;
  tm.tm_mday=mday;
  tm.tm_hour=hour;
  tm.tm_min=min;
  tm.tm_sec=sec;
  tm.tm_isdst=0;   // no daylight saving

  if(tm.tm_year>=year) {
    WX_RETURN(WXM_ERANGE);  // value conversion failed
  }

  {
    const std::time_t tt=std::mktime(&tm);
    if(tt==(std::time_t)(-1)) {
      WX_RETURN(WXM_ERANGE);
    }
    _wxt.assign(WxTime::wx__time_t2secs(tt),0);  // nano second set to zero
  }
  _year=tm.tm_year+1900;
  _month=tm.tm_mon+1;
  _mday=tm.tm_mday;
  _hour=tm.tm_hour;
  _min=tm.tm_min;
  _sec=tm.tm_sec;
  _wday=tm.tm_wday;
  _yday=tm.tm_yday;
  return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxRet WxDate::add(const WxTime &tm) throw(std::exception)
try {
 WxRet r=assign(tm+_wxt);
 if(r!=OK) {
   if(r==WXM_ERANGE) {
     WX_RETURN(WXM_ERANGE);
   }
   WX_THROW(Wx_general_error());
 }
 return(OK);
}
catch(const WxTime::Fault& e) {
  if(e==WXM_ERANGE) {
    WX_RETURN(WXM_ERANGE);
  }
  WX_THROW(Wx_general_error());
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(...) {
  WX_THROW(Wx_general_error());
};
/*
WxRet WxDate::add(int year,int month,int mday,
		     int hour,int min,int sec) throw(std::exception)
try {
 if((year<0)||(month<0)||(mday<0)||(hour<0)||(min<0)||(sec<0)) {
   WX_RETURN(WXM_EINVAL);
 }
 WxRet r=assign(_year+year,_month+month,_mday+mday,
                _hour+hour,_min+min,_sec+sec);
 if(r!=OK) {
   if(r==WXM_EINVAL) {
     WX_RETURN(WXM_ERANGE);
   }
   if(r==WXM_ERANGE) {
     WX_RETURN(WXM_ERANGE);
   }
   WX_THROW(Wx_general_error());
 }
 return(OK);
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(...) {
  WX_THROW(Wx_general_error());
};
*/
const WxDate & WxDate::operator =(const WxTime &rhs) throw(std::exception,Fault)
try {
 WxRet r=assign(rhs);
 if(r!=OK) {
   WX_THROW( Fault(r) );
 }
 return *this;
}
catch(const WxDate::Fault&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(...) {
  WX_THROW(Wx_general_error());
};

const WxDate & WxDate::operator +=(const WxTime &rhs) throw(std::exception,Fault)
try {
 WxRet r=assign(_wxt+rhs);
 if(r!=OK) {
   if(r==WXM_ERANGE) {
     WX_THROW( Fault(WXM_ERANGE) );
   }
   WX_THROW(Wx_general_error());
 }
 return *this;
}
catch(const WxDate::Fault&) {
  throw;
}
catch(const WxTime::Fault& e) {
  if(e==WXM_ERANGE) {
    WX_THROW( Fault(WXM_ERANGE) );
  }
  WX_THROW(Wx_general_error());
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxStr Wx::what_is(const WxDate& date) throw(std::exception)
try {
 WxRet r;
 WxStr str;
 
 if((r=Wx::append_number(str, date.year(), 10))!=OK) {
   WX_THROW(Wx_general_error());
 }
 str+='-';

 if((r=Wx::append_number(str, date.month(), 10))!=OK) {
   WX_THROW(Wx_general_error());
 }
 str+='-';

 if((r=Wx::append_number(str, date.mday(), 10))!=OK) {
   WX_THROW(Wx_general_error());
 }
 str+=' ';

 if((r=Wx::append_number(str, date.hour(), 10))!=OK) {
   WX_THROW(Wx_general_error());
 }
 str+=':';

 if((r=Wx::append_number(str, date.min(), 10))!=OK) {
   WX_THROW(Wx_general_error());
 }
 str+='.';

 if((r=Wx::append_number(str, date.sec(), 10))!=OK) {
   WX_THROW(Wx_general_error());
 }
 str+= " (";
 str+= char(date.wday()+'0');
 str+=')';

 return(str);
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxRet Wx::set_systime(const WxDate& t) throw(std::exception)
try {
 return Wx::set_systime(t.utc_time()); 
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxDate operator +(const WxDate& dt,const WxTime& tm) throw(std::exception,WxDate::Fault)
try {
 return WxDate(dt.utc_time()+tm); 
}
catch(const WxDate::Fault&) {
 throw;
} 
catch(const WxTime::Fault& e) {
  if(e==WXM_ERANGE) {
    WX_THROW( WxDate::Fault(WXM_ERANGE) );
  }
  WX_THROW(Wx_general_error());
}
catch(const Wx_bad_alloc&) {
 throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxDate operator +(const WxTime& tm,const WxDate& dt) throw(std::exception,WxDate::Fault)
try {
 return WxDate(dt.utc_time()+tm); 
}
catch(const WxDate::Fault&) {
 throw;
} 
catch(const WxTime::Fault& e) {
  if(e==WXM_ERANGE) {
    WX_THROW( WxDate::Fault(WXM_ERANGE) );
  }
  WX_THROW(Wx_general_error());
}
catch(const Wx_bad_alloc&) {
 throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(...) {
  WX_THROW(Wx_general_error());
};
