/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   WxCond is for the thread to suspend execution waiting to resume

  [Avoided C Use] pthread_cond_t
           pthread_cond_init, pthread_cond_destroy
           pthread_cond_wait, pthread_cond_signal, pthread_cond_broadcast
           pthread_cond_timedwait

  Note: Some of the error messages are based on Linux Programmer's Manual.
*/

#ifndef WXCOND_H__
#define WXCOND_H__

#define WXCOND_VERSION 8

#include "wxmutex.h"
#include "wxtime.h"

/* 
*/
class WxCond {
  public:
    static const char class_name[];
    WX_DECLARE_FAULT;

    WxCond() throw(std::exception);

    ~WxCond() throw(std::exception);

    //WxRet reset(void) throw(std::exception);

    void signal(void) throw(std::exception);

    void broadcast(void) throw(std::exception);

    WxRet wait(WxLock &mtx) throw(std::exception);

    WxRet wait(WxLock &mtx, const WxTime &abstime) throw(std::exception);

  private:
    long _sig;                                 // class signature
    ::pthread_cond_t  _cond;

    WxCond(const WxCond&);                     // no copy constructor 
    const WxCond& operator =(const WxCond&);   // no assign operator
    bool operator ==(const WxCond&);           // no equal operator
};

#endif
