/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxcond.h"

const char WxCond::class_name[]="WxCond";

WxCond::WxCond() throw(std::exception)
try : _sig(WX_NONE_ID)
{
 //
 // man says never return error code (always return 0?)
 // WxCond uses default pthread_cond_t. As there is static initializer
 // ,pthread_cond_init(&_cond,NULL) should be always successful.
 //
 ::pthread_cond_init(&_cond,NULL);
 _sig=WXCOND_ID;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxCond::~WxCond() throw(std::exception)
try {
 if(_sig!=WXCOND_ID) {
   WX_THROW(Wx_general_error());
 }
 _sig=WX_NONE_ID;

 int v;
 for(int i=0; i<5; ++i) {
   v=::pthread_cond_destroy(&_cond);
   if(v==0) {
     return;      // succeed
   }
   if(v==EBUSY) {
     // 
     // Try to wakeup threads waiting on _cond to have them chance
     // to leave (with bad object signature)
     //
     ::pthread_cond_broadcast(&_cond);
     Wx__Base::yield();
   } else {
     break;
   }
 }
 WX_THROW( Wx_bad_errno(v) );
}
catch(const Wx_except&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

/* seemd not necessary and would not conform the definition for reset
WxRet WxCond::reset(void) throw(std::exception)
try {
 if(_sig!=WXCOND_ID) {
   WX_THROW(Wx_general_error());
 }

 //
 // Make _cond default by destroying and initializing it again
 //
 const int v=::pthread_cond_destroy(&_cond);
 if(v==0) {
   ::pthread_cond_init(&_cond,NULL);  // man. never return error code
   return(OK);
 }
 if(v==EBUSY) {
   WX_RETURN(WXM_EBUSY);
 }
 WX_THROW( Wx_bad_errno(v) );
}
catch(const Wx_except&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};
*/

void WxCond::signal(void) throw(std::exception)
try {
 if(_sig!=WXCOND_ID) {
   WX_THROW(Wx_general_error());
 }
 ::pthread_cond_signal(&_cond);  // man. never return error code
 return;
}
catch(const Wx_except&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

void WxCond::broadcast(void) throw(std::exception)
try {
 if(_sig!=WXCOND_ID) {
   WX_THROW(Wx_general_error());
 }
 ::pthread_cond_broadcast(&_cond); // man. never return error code
 return;
}
catch(const Wx_except&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxRet WxCond::wait(WxLock &mtx) throw(std::exception)
try {
 if(_sig!=WXCOND_ID) {
   WX_THROW(Wx_general_error());
 }
 if(mtx._pmtx==0) {
   WX_RETURN(WXM_EFAULT);   // WxLock is empty
 }
 ::pthread_cond_wait(&_cond,&((mtx._pmtx)->_mtx)); // man says never return errcode
 return(WXM_EINTR);
}
catch(const Wx_except&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};

WxRet WxCond::wait(WxLock &mtx, const WxTime &abstime) throw(std::exception)
try {
 if(_sig!=WXCOND_ID) {
   WX_THROW(Wx_general_error());
 }
 if(mtx._pmtx==0) {
   WX_RETURN(WXM_EFAULT);   // WxLock is empty
 }
 
 // pthread interpret time_t from 1970-1-1 0800
 struct timespec ts;
 if(WxTime::wx__secs2time_t(abstime.secs(),ts.tv_sec)!=0) {
   WX_RETURN(WXM_ERANGE);   // conversion faiure
 }
 ts.tv_nsec=abstime.nano();

 const int v=::pthread_cond_timedwait(&_cond,&((mtx._pmtx)->_mtx),&ts);
 WX_RETURN(WxErrMsg(v));
}
catch(const Wx_except&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
  WX_THROW(Wx_general_error());
};
