/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   This file should conform to the documentation in file wxchrfile.3wx
*/

#include "wxchrfile.h"

const char WxChrFile::class_name[]="WxChrFile";

WxChrFile::WxChrFile(WxFileHandle fh) throw(std::exception,WxRet)
try : WxByteFlow(fh) {
}
catch(const WxByteFlow::Fault& e) {
  WX_THROW( Fault(e) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxChrFile::WxChrFile(const WxChrFile &src) throw(std::exception,WxRet)
try : WxByteFlow(src) {
}
catch(const WxByteFlow::Fault& e) {
  WX_THROW( Fault(e) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxChrFile::~WxChrFile() throw(std::exception)
try {
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxChrFile::drain(void) throw(std::exception)
try {
  WX_RETURN( WxByteFlow::drain() );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxChrFile::open(const WxPathName& pathname,int f) throw(std::exception)
try {
  if(f&O_CREAT) {
    WX_RETURN(WXM_EINVAL);
  }
  WX_RETURN( WxByteFlow::wx_open(pathname,f) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxChrFile::assignf(const WxChrFile& src) throw(std::exception)
try {
  WX_RETURN( WxByteFlow::wx_assignf(static_cast<const WxByteFlow&>(src)) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxChrFile::assignf(WxFileHandle fh) throw(std::exception)
try {
  // stat fh
  if(fh.is_default()==false) {
    WxFileStat stt;
    const WxRet r=fh.stat(stt);
    if(r!=OK) {
      WX_RETURN(r);
    } 
    if(stt.is_chr()==false) {
      WX_RETURN(WXM_EBADF);
    }
  }
  WX_RETURN( WxByteFlow::wx_assignf(fh) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};
