/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxbyteflow.h"
#include "wxstr.h"

const char WxByteFlow::class_name[]="WxByteFlow";

WxByteFlow::WxByteFlow() throw()
try : _hdl() {
}
catch(...) {
 WX_ABORT();
};

WxByteFlow::WxByteFlow(WxFileHandle fh) throw(std::exception,WxRet)
try : _hdl() {
 if(fh.is_default()) {
   return;
 }
 const WxRet r=_hdl.assign(fh.fd());
 if(r!=OK) {
   WX_THROW( Fault(r) );
 }
}
catch(const Wx__Handle::Fault& e) {
  WX_THROW( Fault(e) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxByteFlow::WxByteFlow(const WxByteFlow &src) throw(std::exception,WxRet)
try : _hdl(src._hdl) {
}
catch(const Wx__Handle::Fault& e) {
  WX_THROW( Fault(e) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxByteFlow::~WxByteFlow() throw(std::exception)
try {
  _hdl.reset();
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxByteFlow::stat(WxFileStat& filestat) const throw(std::exception)
try {
 //
 // Assert that _hdl.fstat failure should not modify filestat.
 //
 WX_RETURN( _hdl.fstat(filestat.wx_stt()) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxByteFlow::reset(void) throw(std::exception)
try {
  WX_RETURN(_hdl.reset());
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxByteFlow::read(void *buf, size_t count, size_t *n_read) throw(std::exception)
try {
  WX_RETURN( _hdl.read(buf,count,n_read) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxByteFlow::max_read(void *buf, size_t count, size_t *n_read) throw(std::exception)
try {
  WX_RETURN( _hdl.max_read(buf,count,n_read) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxByteFlow::write(const void *buf, size_t count, size_t *n_written) throw(std::exception)
try {
  WX_RETURN( _hdl.write(buf,count,n_written) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxByteFlow::drain(void) throw(std::exception)
try {
  WX_RETURN(_hdl.fdatasync());
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxByteFlow::wx_devname(WxPathName& pathname) const throw(std::exception)
try {
  WxStr pn;
  WxRet r=_hdl.ttyname(pn);
  if(r!=OK) {
    WX_RETURN(r);
  }
  r=pathname.assign(pn);
  WX_RETURN(r);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};
