/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

  Note: Some of the error messages are based on Linux Programmer's Manual.
*/

#ifndef WX_SOCKADDR_H__
#define WX_SOCKADDR_H__
#define WX_SOCKADDR_VERSION 8

#include "wxret.h"
#include <sys/types.h>
#include <sys/socket.h>

//
// Base protocol class of socket address
//
class Wx_SockAddr {
  public:
    //
    // [Internal] The default object is recognized by the size
    //            "*slen_ptr()=Wx_SockAddr::DefaultSockLen" set the
    //            object default.
    //         
    // Note: sockaddr.sa_family is setup by the derived class and should
    //       be constant throughout object life time.
    //
    static const size_t DefaultSockLen=sizeof(sa_family_t);

    //
    // [Internal] Get the struct sockaddr address
    //
    // Note: Derived class should always setup sockaddr.sa_family data member.
    //       Codes in WxSockFile depends on this to identify the data structure.
    //
    virtual struct sockaddr* saddr_ptr(void) throw()=0;
    virtual const struct sockaddr* const_saddr_ptr(void) const throw()=0;

    //
    // [Internal] Get the buffer size that saddr_ptr() pointed 
    //            (value must be >= DefaultSockLen)
    //
    virtual size_t saddr_size(void) const throw()=0;

    //
    // [Internal] Get the address of the variable that specifies the valid data
    //            length saddr_ptr() pointed.
    //
    virtual  socklen_t* slen_ptr(void) throw()=0;
    virtual const socklen_t* const_slen_ptr(void) const throw()=0;
};

#endif
