/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

  Wx__Base intends to provide the basic support for WxLIb functions.

  Note: This file is intended to be included in wxdefs.h
*/
#ifndef WX__BASE_H__
#define WX__BASE_H__

#include <pthread.h>

class Wx__Base {
  public:
    //
    // [Syn] Mark cancellation point
    //
    inline static void cancel_point(void) throw()
        { ::pthread_testcancel(); };   // errno is assumed not modified

    //
    // [Syn] Yield thread execution
    //
    // [Ret] 0= ok
    //       otherwise= failure, errno
    //
    inline static int yield(void) throw() 
        { return (::pthread_yield()==0)? 0:errno; };
 
    //
    // [Syn] Abort the program
    //
    // Note: I had problem with this function inlined.
    //
    static void abort(void) throw() __attribute__ ((__noreturn__));
};

#endif
