/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Build: make demo_thread
 */
#include "wxthread.h"
#include "wxtime.h"

//
// The demo thread class
//
class THRD : public WxThread {
  public:
    THRD() throw(std::exception) {};
    ~THRD() throw(std::exception)
        {
         cancel();       // stop possible running thread before others
         wait_stopped();
        };
  protected:
    //
    // Reimplement of the pure virtual function to run the thread
    //
    WxRet tmain(void) throw() {
       for(;;) {
         Wx::sleep_till(Wx::now()+WxTime(0,500000000));  // delay and cancel point
         WX_NOCANCEL;       // not cancelable now
         std::cerr << "Z";  // print 'Z' in the endless loop
       }
       return(OK);
    };

    void tmain_enter(void) throw() {
       std::cerr << "THRD thread entered...\n";
    };
    void tmain_leave(void) throw() {
       std::cerr << " ...Oh! THRD had to leave\n";
    };
};

int main(void)
try {
 WxRet r;
 THRD thrd;
 
 // Begin the thread
 if((r=thrd.begin())!=OK) {
   WX_HERE(r); throw(r);
 }

 // Give it five seconds to show 'Z's
 Wx::sleep_till(Wx::now()+WxTime(5,0));

 // Cancel the thread (signal sent, the thread may not terminated after)
 if((r=thrd.cancel())!=OK) {
   WX_HERE(r); throw(r);
 }

 // Wait until the thread terminated
 if((r=thrd.wait_stopped())!=OK) {
   WX_HERE(r); throw(r);
 }

 // Get the exit errmsg of the thread. 
 r=thrd.exit_code(); WX_HERE(r); // Make it says from here
 if(r!=WXM_THRDCAN) {
   WX_HERE(r); throw(r);
 }

 // Print the results.
 std::cerr << "main() report: canceled that 'Z'ing thread, it exited :"
           << Wx::what_is(r) << std::endl;
 
 return(0);
}
catch(const WxRet& e) {
 std::cerr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << "std::exception\n";
 return(-1);
}
