/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

    Build: make demo_errmsg
 */
#include "wxret.h"
#include "wxstr.h"

//
// Define a errmsg to demo
//
const WxErrMsg E001=WxErrMsg::enroll("New defined errmsg E001");

int main(void)
try {
 //
 // Print errno 0-127
 //
 for(int i=0; i<=WxErrMsg::MaxErrNo; ++i) {
   WxErrMsg ei(i);
   std::cout << i << "  " << Wx::what_is(ei) << std::endl;
 }
 //
 // Print the WxLib added errmsg's
 //
 std::cout << std::endl;
 std::cout<< "WXM_THRDCAN  " << Wx::what_is(WXM_THRDCAN) << std::endl;
 std::cout << "WXM_NDEFAULT " << Wx::what_is(WXM_NDEFAULT) << std::endl;
 std::cout << "WXM_DIVZERO " << Wx::what_is(WXM_DIVZERO) << std::endl;
 std::cout << "WXM_MATHNEG " << Wx::what_is(WXM_MATHNEG) << std::endl;

 //
 // Print the note
 //
 std::cerr << "\n -- Note --\n";
 std::cerr << "E001=" << Wx::what_is(E001) << std::endl;
 std::cerr << "WxErrMsg()=" << Wx::what_is(WxErrMsg()) << std::endl;
 std::cerr << "WxErrMsg(0)=OK=" << Wx::what_is(OK) << std::endl;
 std::cerr << "OK=" << Wx::what_is(OK) << std::endl;

 return(0);
}
catch(const Wx_except& e) {
 std::cerr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << e.what() << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << "main() caught unkown exception\n";
}
