/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Basic test of WxTermios

   Build: make chk_termios
*/

#include "wxterminal.h"
#include <cstdlib>
#include <unistd.h>
#include <sys/types.h>

#if WXTERMIOS_VERSION!=8
#error Test code is for WXTERMIOS_VERSION 8
#endif

//
// Check for default object
//
static void t_assert_default(const WxTermios& dobj)
{
 static WxTermios tobj;

 if(dobj.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(dobj.is_default()) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(tobj!=dobj) {
   WX_THROW( Wx_general_error() );
 }
 if(tobj==dobj) {
 } else {
   WX_THROW( Wx_general_error() );
 }
};

//
// Check basic operations on default object
//
static void t1(void)
{
 WxRet r;
 WxTermios NObj;    // non default object for the test
 t_assert_default(NObj);

 if((r=NObj.setispeed(B50))!=OK) {
   WX_HERE(r); throw(r);
 }
 if(NObj.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 
 // constructor
 {
   WxTermios tmp;
   t_assert_default(tmp);

   WxTermios tmp1(tmp);
   t_assert_default(tmp1);
   if(tmp==tmp1) {
   } else {
     WX_THROW( Wx_general_error() );
   }
   if(tmp!=tmp1) {
     WX_THROW( Wx_general_error() );
   }

   WxTermios tmp2(NObj);
   if(tmp2.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(tmp2==NObj) {
   } else {
     WX_THROW( Wx_general_error() );
   }
   if(tmp2!=NObj) {
     WX_THROW( Wx_general_error() );
   }
 }

 // reset
 {
   WxTermios tmp;
   t_assert_default(tmp);
   tmp.reset();
   t_assert_default(tmp);
 }

 // assign
 {
   WxTermios tmp;
   t_assert_default(tmp);
   tmp.assign(WxTermios());
   t_assert_default(tmp);

   tmp.assign(NObj);
   if(tmp!=NObj) {
     WX_THROW( Wx_general_error() );
   }

   // operator=
   WxTermios tmp1(NObj);
   if(tmp1.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   tmp1=tmp=WxTermios();
   t_assert_default(tmp);
   t_assert_default(tmp1);
   
   tmp.assign(NObj);
   if(tmp!=NObj) {
     WX_THROW( Wx_general_error() );
   }
 }

 // get/set i/o speed
 {
   WxTermios tmp;
   t_assert_default(tmp);

   if((r=tmp.setispeed(B134))!=OK) {
     WX_HERE(r); throw(r);
   }
   if(tmp.getispeed()!=B134) {
     WX_THROW( Wx_general_error() );
   }

   if((r=tmp.setospeed(B150))!=OK) {
     WX_HERE(r); throw(r);
   }
   if(tmp.getospeed()!=B150) {
     WX_THROW( Wx_general_error() );
   }
 }

 // iflag
 {
   WxTermios tmp;
   t_assert_default(tmp);

   tmp.iflag(1);
   if(tmp.iflag()!=1) {
     WX_THROW( Wx_general_error() );
   }
   tmp.iflag_or(7);
   if(tmp.iflag()!=7) {
     WX_THROW( Wx_general_error() );
   }
   tmp.iflag_and(2);
   if(tmp.iflag()!=2) {
     WX_THROW( Wx_general_error() );
   }
 }

 // oflag
 {
   WxTermios tmp;
   t_assert_default(tmp);

   tmp.oflag(1);
   if(tmp.oflag()!=1) {
     WX_THROW( Wx_general_error() );
   }
   tmp.oflag_or(7);
   if(tmp.oflag()!=7) {
     WX_THROW( Wx_general_error() );
   }
   tmp.oflag_and(2);
   if(tmp.oflag()!=2) {
     WX_THROW( Wx_general_error() );
   }
 }

 // cflag
 {
   WxTermios tmp;
   t_assert_default(tmp);

   tmp.cflag(1);
   if(tmp.cflag()!=1) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cflag_or(7);
   if(tmp.cflag()!=7) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cflag_and(2);
   if(tmp.cflag()!=2) {
     WX_THROW( Wx_general_error() );
   }
 }

 // lflag
 {
   WxTermios tmp;
   t_assert_default(tmp);

   tmp.lflag(1);
   if(tmp.lflag()!=1) {
     WX_THROW( Wx_general_error() );
   }
   tmp.lflag_or(7);
   if(tmp.lflag()!=7) {
     WX_THROW( Wx_general_error() );
   }
   tmp.lflag_and(2);
   if(tmp.lflag()!=2) {
     WX_THROW( Wx_general_error() );
   }
 }

 // cc
 {
   WxTermios tmp;
   t_assert_default(tmp);

   tmp.cc_VSTOP(5);
   if(tmp.cc_VSTOP()!=5) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VSTART(4);
   if(tmp.cc_VSTART()!=4) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VSUSP(3);
   if(tmp.cc_VSUSP()!=3) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VQUIT(2);
   if(tmp.cc_VQUIT()!=2) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VKILL(1);
   if(tmp.cc_VKILL()!=1) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VERASE(6);
   if(tmp.cc_VERASE()!=6) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VEOL(7);
   if(tmp.cc_VEOL()!=7) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VEOF(8);
   if(tmp.cc_VEOF()!=8) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VINTR(9);
   if(tmp.cc_VINTR()!=9) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VTIME(15);
   if(tmp.cc_VTIME()!=15) {
     WX_THROW( Wx_general_error() );
   }
   tmp.cc_VMIN(16);
   if(tmp.cc_VMIN()!=16) {
     WX_THROW( Wx_general_error() );
   }
 }
};

static void t2(void)
{
};

static WxStr chdr="+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n";
int main(void) throw()
try {
 std::cout << "Checking wxtermios.h ...\n";

 if(WxStr(WxTermios::class_name)!="WxTermios") {
   WX_THROW( Wx_general_error() );
 }
 t1();
 t2();
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
