/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Check Wx::stdin

   Build: make chk_stdin

   Note: Test data files should exist in the working directory
         Files may be created in the working directory and unlinked
*/

#include "wxterminal.h"
#include "wxregfile.h"
#include "chk_data.h"
#include <unistd.h>

#if WXFILEHANDLE_VERSION!=8
#error Test code is for WXFILEHANDLE_VERSION 8
#endif
#if WXREGFILE_VERSION!=8
#error Test code is for WXREGILE_VERSION 8
#endif
#if WXCHRFILE_VERSION!=8
#error Test code is for WXCHRILE_VERSION 8
#endif
#if WXTERMINAL_VERSION!=8
#error Test code is for WXTERMINAL_VERSION 8
#endif

//
// Setup the test 
//
static void setup_test(void)
{
};

//
// Undo setup_test
//
static void close_test(void)
{
};

//
// Read stdin as a regular file (the file have to be TestFile_2A)
//
static void t_stdin_reg(void)
{
  std::cout << "stdin is a regular file\n";
  WxRet r;
  WxRegFile regf;

  if((r=regf.assignf(Wx::stdin))!=OK) {
     WX_HERE(r); throw(r);
  }

  // read stdin file
  char buf[8];
  size_t n_rd;
  if((r=regf.read(buf,sizeof(buf),&n_rd))!=OK) {
    WX_HERE(r); throw(r);
  }
  if(n_rd!=2) {
    WX_THROW( Wx_general_error() );
  }
  if((buf[0]!='\n')||(buf[1]!='\n')) {
    WX_THROW( Wx_general_error() );
  }
};

//
// Read stdin as a character file
//
static void t_stdin_chr(void)
{
   std::cout << "stdin is a character file\n";
   WxRet r;
   WxChrFile chrf;

   if((r=chrf.assignf(Wx::stdin))!=OK) {
     WX_HERE(r); throw(r);
   }

   // read
   std::cout << "stdin (input any string): " << std::flush;
   char buf[8];
   size_t n_rd;
   if((r=chrf.read(buf,sizeof(buf),&n_rd))!=OK) {
     WX_HERE(r); throw(r);
   }
   if(n_rd<=0) {
     std::cout << " Nothing input\n";
   } else {
     if(buf[n_rd-1]!='\n') {
       std::cout << " Check interrupted (input>" << sizeof(buf)-1 << ")\n"
                    " type cntrl-D and run again\n";
       while(chrf.max_read(buf,sizeof(buf),&n_rd)!=OK) {
         // flush input
       }
       WX_THROW( Wx_general_error() );  // last char from stdin should be LF
                                  // ok if input is more than sizeof(buf)-1
     }
     --n_rd;
     WxStr str;
     str.assign(buf,n_rd);
     std::cout << "Echo the input(" << n_rd << ")=\"" << str << '"';
     if(n_rd>sizeof(buf)) {
       WX_THROW( Wx_general_error() );
     }
     if(n_rd==sizeof(buf)) {
       std::cout << " Only tested " << sizeof(buf) << " characters";
     }
     std::cout << std::endl;
   }
};

//
// Check Wx::stdin
//
static void t_stdin(void)
{
 WxRet r;

 // startup condition check
 if(Wx::stdin.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 if(Wx::stdin.fd()!=STDIN_FILENO) {
   WX_THROW( Wx_general_error() );
 }

 // stat
 WxFileStat stt;
 if((r=Wx::stdin.stat(stt))!=OK) {
   WX_HERE(r); throw(r);
 }
 if(stt.is_chr()) {
   t_stdin_chr();
   return;
 }
 if(stt.is_reg()) {
   t_stdin_reg();
   return;
 }
 WX_THROW( Wx_general_error() );  // neither chr nor reg file
};

static void t_exception(void)
{
 //
 // Test copy constructor exception
 //
 try {
 }
 catch(...) {
   throw;
 };

 //
 // Test destructor exception
 //
 {
 }
};

static WxStr chdr="+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n";
int main(void) throw()
try {
 try {
   std::cout << "Checking Wx::stdin ...\n";
   setup_test();
   t_stdin();
   t_exception();
   close_test();
   std::cout << "Checked OK\n";
 }
 catch(...) {
   close_test();
   throw;
 }
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
