/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Check Wx::stderr

   Build: make chk_stderr

   Note: Test data files should exist in the working directory
         Files may be created in the working directory and unlinked
*/

#include "wxterminal.h"
#include "wxregfile.h"
#include "chk_data.h"
#include <unistd.h>

#if WXFILEHANDLE_VERSION!=8
#error Test code is for WXFILEHANDLE_VERSION 8
#endif
#if WXREGFILE_VERSION!=8
#error Test code is for WXREGILE_VERSION 8
#endif
#if WXCHRFILE_VERSION!=8
#error Test code is for WXCHRILE_VERSION 8
#endif
#if WXTERMINAL_VERSION!=8
#error Test code is for WXTERMINAL_VERSION 8
#endif

//
// Setup the test 
//
static void setup_test(void)
{
};

//
// Undo setup_test
//
static void close_test(void)
{
};

//
// Write stdout as a regular file
//
static void t_stderr_reg(void)
{
  // std::cerr is being testing, use std::cout for message
  std::cout<< "stderr is a regular file\n" << std::flush;

  WxRet r;
  WxRegFile regf;

  if((r=regf.assignf(Wx::stderr))!=OK) {
     WX_HERE(r); throw(r);
  }
  // write stdout file
  const char buf[]="\"This string is sent to Wx::stderr (reg)\n\"";
  size_t n_wr;
  if((r=regf.write(buf,sizeof(buf),&n_wr))!=OK) {
    WX_HERE(r); throw(r);
  }
  if(n_wr!=sizeof(buf)) {
    WX_THROW( Wx_general_error() );
  }
  if((r=regf.drain())!=OK) {
    WX_HERE(r); throw(r);
  }
};

//
// Read stdout as a character file
//
static void t_stderr_chr(void)
{
   // std::cerr is being testing, use std::cout for message
   std::cout << "stderr is a character file\n";
   WxRet r;
   WxChrFile chrf;

   if((r=chrf.assignf(Wx::stderr))!=OK) {
     WX_HERE(r); throw(r);
   }

   // Write
   const char buf[]="\"This string is sent to Wx::stderr(chr)\n\"";
   size_t n_wr;
   if((r=chrf.write(buf,sizeof(buf),&n_wr))!=OK) {
     WX_HERE(r); throw(r);
   }
   if(n_wr!=sizeof(buf)) {
      WX_THROW( Wx_general_error() );
   }
};

//
// Check Wx::stdout
//
static void t_stderr(void)
{
 WxRet r;

 // startup condition check
 if(Wx::stderr.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 if(Wx::stderr.fd()!=STDERR_FILENO) {
   WX_THROW( Wx_general_error() );
 }

 // stat
 WxFileStat stt;
 if((r=Wx::stderr.stat(stt))!=OK) {
   WX_HERE(r); throw(r);
 }
 if(stt.is_chr()) {
   t_stderr_chr();
   return;
 }
 if(stt.is_reg()) {
   t_stderr_reg();
   return;
 }
 WX_THROW( Wx_general_error() );  // neither chr nor reg file
};

static void t_exception(void)
{
 //
 // Test copy constructor exception
 //
 try {
 }
 catch(...) {
   throw;
 };

 //
 // Test destructor exception
 //
 {
 }
};

static WxStr chdr="+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n";
int main(void) throw()
try {
 try {
   // std::cerr is being testing, use std::cout for message
   std::cout << "Checking Wx::stderr ...\n";

   setup_test();
   t_stderr();
   t_exception();
   close_test();

   // std::cout is being testing, use std::cout for message
   std::cout << "Checked OK\n";
 }
 catch(...) {
   close_test();
   throw;
 }
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
