/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Check WxSockAddrLocal public members

   Build: make chk_sockaddrlocal

   Note: Test data files should exist in the working directory
         Files may be created in the working directory and unlinked
*/

#include "wxsockaddrlocal.h"
#include <memory>

#if WXSOCKADDRLOCAL_VERSION!=8
#error Test code is for WXSOCKADDRLOCAL_VERSION 8
#endif

//
// Assert ff is default
//
static void assert_default(const WxSockAddrLocal& ff)
{
 static const WxSockAddrLocal Def_Obj;

 if(ff.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(ff.family()!=AF_LOCAL) {
   WX_THROW( Wx_general_error() );
 }
 if(ff!=Def_Obj) {
   WX_THROW( Wx_general_error() );
 }
 if(ff==Def_Obj) {
 } else {
   WX_THROW( Wx_general_error() );
 }
};

//
// Check basic operations on default object
//
static void t1(void)
{
 WxRet r;

 // constructor
 {
   WxSockAddrLocal a0;
   assert_default(a0);

   WxSockAddrLocal a1(a0);
   assert_default(a1);
   if(a0.family()!=AF_LOCAL) {
     WX_THROW( Wx_general_error() );
   }
 }

 // operator==/!=
 {
   WxSockAddrLocal a0,a1;
   if(a0==a1) {
   } else {
     WX_THROW( Wx_general_error() );
   }
   if(a0!=a1) {
     WX_THROW( Wx_general_error() );
   }

   if((r=a1.assign(WxPathName("helo")))!=OK) {
     WX_HERE(r); throw(r);
   }
   if(a1==a0) {
     WX_THROW( Wx_general_error() );
   }
   if(a1!=a0) {
   } else {
     WX_THROW( Wx_general_error() );
   }
 }
 
 // reset
 {
   WxSockAddrLocal a0;
   a0.reset();
   assert_default(a0);
 }

 // assign
 {
   WxSockAddrLocal a0;
   WxSockAddrLocal a1;
   a1.assign(a0);
   assert_default(a0);
   assert_default(a1);

   if((r=a1.assign(WxPathName()))!=OK) {
     WX_HERE(r); throw(r);
   }
   if((r=a1.assign(WxPathName("helo")))!=OK) {
     WX_HERE(r); throw(r);
   }
 }

 // operator=
 {
   WxSockAddrLocal a0;
   WxSockAddrLocal a1;
   a1=a0;
   assert_default(a0);
   assert_default(a1);

   if((r=a0.assign(WxPathName("helo")))!=OK) {
     WX_HERE(r); throw(r);
   }
   a1=a0;
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a1.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a1!=a0) {
     WX_THROW( Wx_general_error() );
   }
   if(a1==a0) {
   } else {
     WX_THROW( Wx_general_error() );
   }
 }

 // get_notation
 {
   WxSockAddrLocal a0;
   assert_default(a0);
   WxStr str;
   
   if((r=a0.get_notation(str))!=WXM_ENOENT) {
     WX_HERE(r); throw(r);
   }
   if(str.is_default()==false) {
     WX_THROW( Wx_general_error() );
   }
 }
};

//
// Check basic operations on non-default object
//
static void t2(void)
{
 WxRet r;
 WxSockAddrLocal A0;
 WxSockAddrLocal N0;

 assert_default(A0);
 assert_default(N0);
 if((r=N0.assign(WxPathName("helo")))!=OK) {
   WX_HERE(r); throw(r);
 }
 if(N0.is_default()) {
   WX_THROW( Wx_general_error() );
 }

 // constructor
 {
   WxSockAddrLocal a0(N0);
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
 }

 // operator==/!=
 {
   WxSockAddrLocal a0(N0),a1(a0);
   if(a1.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a0==a1) {
   } else {
     WX_THROW( Wx_general_error() );
   }
   if(a0!=a1) {
     WX_THROW( Wx_general_error() );
   }
 }
 
 // reset
 {
   WxSockAddrLocal a0(N0);
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   a0.reset();
   assert_default(a0);
 }

 // assign
 {
   WxSockAddrLocal a0(N0);
   a0.assign(N0);
   a0.assign(A0);
   assert_default(a0);
 }

 // operator=
 {
   WxSockAddrLocal a0(N0);
   a0=A0;
   assert_default(a0);
 }

 // get_notation
 {
   WxSockAddrLocal a0(N0);
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   WxStr str;
   
   if((r=a0.get_notation(str))!=OK) {
     WX_HERE(r); throw(r);
   }
   if(str!="helo") {   // N0 notation is "helo"
     WX_THROW( Wx_general_error() );
   }
 }
};

static void t_exception(void)
{
 //
 // Test copy constructor exception
 //
 try {
   char tbuf[256];    // should cause ENAMETOOLONG error
   std::memset(tbuf,'A',sizeof(tbuf));
   tbuf[sizeof(tbuf)-1]=0;
   WxPathName path(tbuf);
   WxSockAddrLocal tmp(path);
   // the following line wont compile ok ???
   // WxSockAddrLocal tmp(WxPathName(tbuf)); 
   //
   WX_THROW( Wx_general_error() );  // no expected exception
 }
 catch(const WxSockAddrLocal::Fault& e) {
   if(e!=WXM_ENAMETOOLONG) {
     WxRet r=e;
     WX_HERE(r); throw(r);
   }
   // FALLTHROUGH 
 }
 catch(...) {
   throw;
 };
};

static WxStr chdr="+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n";
int main(void) throw()
try {
 std::cout << "Checking wxsockaddrlocal.h ...\n";
 t1();
 t2();
 t_exception();
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
