/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Check WxSockAddrINet public members

   Build: make chk_sockaddrlocal

   Note: Test data files should exist in the working directory
         Files may be created in the working directory and unlinked
*/

#include "wxsockaddrinet.h"
#include <memory>

#if WXSOCKADDRINET_VERSION!=8
#error Test code is for WXSOCKADDRINET_VERSION 8
#endif

//
// Assert ff is default
//
static void assert_default(const WxSockAddrINet& ff)
{
 static const WxSockAddrINet Def_Obj;

 if(ff.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(ff.family()!=AF_INET) {
   WX_THROW( Wx_general_error() );
 }
 if(ff!=Def_Obj) {
   WX_THROW( Wx_general_error() );
 }
 if(ff==Def_Obj) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(ff.port()!=0) {
   WX_THROW( Wx_general_error() );
 }
 if(ff.ip()!=INADDR_ANY) {
   WX_THROW( Wx_general_error() );
 }
};

//
// Check basic operations on default object
//
static void t1(void)
{
 WxRet r;

 // constructor
 {
   WxSockAddrINet a0;
   assert_default(a0);

   WxSockAddrINet a1(a0);
   assert_default(a0);
   assert_default(a1);
   
   WxSockAddrINet a2(1,2);
   if(a2.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a2.family()!=AF_INET) {
     WX_THROW( Wx_general_error() );
   }
   if(a2.port()!=2) {
     WX_THROW( Wx_general_error() );
   }

   WxSockAddrINet a3("1.2.3.4",9);
   if(a3.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a3.family()!=AF_INET) {
     WX_THROW( Wx_general_error() );
   }
   if(a3.port()!=9) {
     WX_THROW( Wx_general_error() );
   }
 }

 // operator==/!=
 {
   WxSockAddrINet a0,a1;
   if(a0==a1) {
   } else {
     WX_THROW( Wx_general_error() );
   }
   if(a0!=a1) {
     WX_THROW( Wx_general_error() );
   }

   a1.assign(3,4);
   if(a1==a0) {
     WX_THROW( Wx_general_error() );
   }
   if(a1!=a0) {
   } else {
     WX_THROW( Wx_general_error() );
   }
 }
 
 // reset
 {
   WxSockAddrINet a0;
   a0.reset();
   assert_default(a0);
 }

 // assign
 {
   WxSockAddrINet a0;
   WxSockAddrINet a1;
   a1.assign(a0);
   assert_default(a0);
   assert_default(a1);

   a0.assign(5,6);
   a1.assign(a0);
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a1!=a0) {
     WX_THROW( Wx_general_error() );
   }
   if(a0.family()!=AF_INET) {
     WX_THROW( Wx_general_error() );
   }
   if(a1.family()!=AF_INET) {
     WX_THROW( Wx_general_error() );
   }
   if(a0.port()!=6) {
     WX_THROW( Wx_general_error() );
   }
   if(a1.port()!=6) {
     WX_THROW( Wx_general_error() );
   }
   
   WxSockAddrINet a2;
   if((r=a2.assign("2.2.3.3",9))!=OK) {
     WX_HERE(r); throw(r);
   }
   a0=a1=a2;
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a1.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a2.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a1!=a0) {
     WX_THROW( Wx_general_error() );
   }
   if(a2!=a1) {
     WX_THROW( Wx_general_error() );
   }
   if(a0.family()!=AF_INET) {
     WX_THROW( Wx_general_error() );
   }
   if(a1.family()!=AF_INET) {
     WX_THROW( Wx_general_error() );
   }
   if(a2.family()!=AF_INET) {
     WX_THROW( Wx_general_error() );
   }
   if(a0.port()!=9) {
     WX_THROW( Wx_general_error() );
   }
   if(a1.port()!=9) {
     WX_THROW( Wx_general_error() );
   }
   if(a2.port()!=9) {
     WX_THROW( Wx_general_error() );
   }
 }

 // operator=
 {
   WxSockAddrINet a0;
   WxSockAddrINet a1;
   a1=a0;
   assert_default(a0);
   assert_default(a1);

   a0.assign(4,5);
   a1=a0;
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a1.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a1!=a0) {
     WX_THROW( Wx_general_error() );
   }
   if(a1==a0) {
   } else {
     WX_THROW( Wx_general_error() );
   }
   if(a0.port()!=5) {
     WX_THROW( Wx_general_error() );
   }
   if(a1.port()!=5) {
     WX_THROW( Wx_general_error() );
   }
 }

 // get_notation
 {
   WxSockAddrINet a0;
   assert_default(a0);
   WxStr str;
   
   if((r=a0.get_notation(str))!=WXM_ENOENT) {
     WX_HERE(r); throw(r);
   }
   if(str.is_default()==false) {
     WX_THROW( Wx_general_error() );
   }
 }
};

//
// Check basic operations on non-default object
//
static void t2(void)
{
 WxRet r;
 WxSockAddrINet A0;
 WxSockAddrINet N0;

 assert_default(A0);
 assert_default(N0);
 N0.assign("12.34.56.78",8);
 if(N0.is_default()) {
   WX_THROW( Wx_general_error() );
 }

 // constructor
 {
   WxSockAddrINet a0(N0);
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
 }

 // operator==/!=
 {
   WxSockAddrINet a0(N0),a1(a0);
   if(a1.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(a0==a1) {
   } else {
     WX_THROW( Wx_general_error() );
   }
   if(a0!=a1) {
     WX_THROW( Wx_general_error() );
   }
 }
 
 // reset
 {
   WxSockAddrINet a0(N0);
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   a0.reset();
   assert_default(a0);
 }

 // assign
 {
   WxSockAddrINet a0(N0);
   if(a0!=N0) {
     WX_THROW( Wx_general_error() );
   }
   a0.assign(N0);
   a0.assign(A0);
   assert_default(a0);
   if((r=a0.assign("1.2.3.4",5))!=OK) {
     WX_HERE(r); throw(r); // this class can assign non-default object
   }
   WxSockAddrINet a1;
   a1.assign(a0);
   if(a1!=a0) {
     WX_THROW( Wx_general_error() );
   }
 }

 // operator=
 {
   WxSockAddrINet a0(N0);
   a0=A0;
   assert_default(a0);
 }

 // get_notation
 {
   WxSockAddrINet a0(N0);
   if(a0.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   WxStr str;
   
   if((r=a0.get_notation(str))!=OK) {
     WX_HERE(r); throw(r);
   }
   if(str!="12.34.56.78") {   // N0 notation is "12.34.56.78"
     std::cerr << str << std::endl;
     WX_THROW( Wx_general_error() );
   }
 }
};

static void t_exception(void)
{
 //
 // Test copy constructor exception
 //
 try {
   WxStr tbuf="abc.efg.1234zzz";    // should cause error
   WxSockAddrINet tmp(tbuf,4);
   WX_THROW( Wx_general_error() );  // no expected exception
 }
 catch(const WxSockAddrINet::Fault& e) {
   if(e!=WXM_EADDRNOTAVAIL) {
     WxRet r=e;
     WX_HERE(r); throw(r);
   }
   // FALLTHROUGH 
 }
 catch(...) {
   throw;
 };
};

static WxStr chdr="+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n";
int main(void) throw()
try {
 std::cout << "Checking wxsockaddrinet.h ...\n";
 t1();
 t2();
 t_exception();
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
