/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Note: This test should be after chk_errmsg

   Build: make chk_ret
*/

#include "wxret.h"
#include "wxstr.h"

#if WXR_RET_VERSION!=8
#error Test code is for WXR_RET_VERSION 8
#endif

//
// Test the public interface
//
static void t1(void)
{

 WxRet r1;              // default constructor
 WxRet r2(WXM_ENOENT);  // construct by errno
 WxRet r3(r2);          // constructor by copy
 WxRet r4(WxErrMsg(0));

 //
 // Basic construct and compare
 //
 if(r1.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(r2.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 if(r3.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 if(r4.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 if(r1==r2) {
   WX_THROW( Wx_general_error() );
 }
 if(r1!=r2) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(r2!=r3) {
   WX_THROW( Wx_general_error() );
 }
 if(r2==r3) {
 } else {
   WX_THROW( Wx_general_error() );
 }

 if(r1==OK) {
   WX_THROW( Wx_general_error() );
 }
 if(r1!=OK) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(OK==r1) {
   WX_THROW( Wx_general_error() );
 }
 if(OK!=r1) {
 } else {
   WX_THROW( Wx_general_error() );
 }

 if(r2==OK) {
   WX_THROW( Wx_general_error() );
 }
 if(r2!=OK) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(r4==OK) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(r4!=OK) {
   WX_THROW( Wx_general_error() );
 }
 if(r4.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 if(r2!=WXM_ENOENT) {
   WX_THROW( Wx_general_error() );
 }
 if(r3!=WXM_ENOENT) {
   WX_THROW( Wx_general_error() );
 }
 if(r4!=OK) {
   WX_THROW( Wx_general_error() );
 }

 // test reset
 r4.reset();
 if(r4.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(r2.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 r4.reset(r2);
 if(r4!=r2) {
   WX_THROW( Wx_general_error() );
 }
 r4.reset(WXM_EBADF);
 if(r4!=WXM_EBADF) {
   WX_THROW( Wx_general_error() );
 }
 r4=WxErrMsg(0);

 //
 // Test assign
 //
 if(r2.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 r4.assign(r2);
 if(r4!=r2) {
   WX_THROW( Wx_general_error() );
 }
 r4.assign(WXM_EBADF);
 if(r4!=WXM_EBADF) {
   WX_THROW( Wx_general_error() );
 }
 try {
  r4=WxErrMsg(-1);
  WX_THROW( Wx_general_error() );
 }
 catch(const Wx_bad_errno& e) {
 }
 r4=WxErrMsg(0);

 //
 // Test operator=
 //
 if(r4==r2) {
   WX_THROW( Wx_general_error() );
 }
 r4=r2;
 if(r4!=r2) {
   WX_THROW( Wx_general_error() );
 }
 r4=WXM_EBADF;
 if(r4!=WXM_EBADF) {
   WX_THROW( Wx_general_error() );
 }
 try {
  r4=WxErrMsg(200);
  WX_THROW( Wx_general_error() );
 }
 catch(const Wx_bad_errno& e) {
 }
 r4=WxErrMsg(0);

 //
 // Test some c_errno
 //
 if(r1.c_errno()!=-1) {
   WX_THROW( Wx_general_error() );
 }
 if(r2.c_errno()!=ENOENT) {
   WX_THROW( Wx_general_error() );
 }
 if(r3.c_errno()!=ENOENT) {
   WX_THROW( Wx_general_error() );
 }
 if(r4.c_errno()!=0) {
   WX_THROW( Wx_general_error() );
 }

 //
 // Test description
 //
 if(Wx::what_is(r2)!=Wx::what_is(r3)) {
   WX_THROW( Wx_general_error() );
 }
};

//
// Test the public interface involving source location.
//
static void t2(void)
{
 static const Wx_SrcLoc loc1(__FILE__,__LINE__);
 static const Wx_SrcLoc loc2(__FILE__,__LINE__);

 if(loc1.src_line()+1!=loc2.src_line()) {
   WX_THROW( Wx_general_error() );
 }
 if(std::string(loc1.src_file())!=std::string(__FILE__)) {
   WX_THROW( Wx_general_error() );
 }
 WxRet r1(WXM_EINVAL); r1.set_sli(&loc1);
 WxRet r2(WXM_EPERM); r2.set_sli(&loc2);
 if(r1!=WXM_EINVAL) {
   WX_THROW( Wx_general_error() );
 }
 if(r1.sli_ptr()!=&loc1) {
   WX_THROW( Wx_general_error() );
 }

 WxRet r3;
 if(r3.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(r3==OK) {
   WX_THROW( Wx_general_error() );
 }
 r3.assign(r2);
 if(r3.is_default()==true) {
   WX_THROW( Wx_general_error() );
 }
 if(r3!=r2) {
   WX_THROW( Wx_general_error() );
 }
 r3.set_sli(&loc2);
 if(r3!=r2) {
   WX_THROW( Wx_general_error() );
 }
 if(r2==r3) {
 } else {
   WX_THROW( Wx_general_error() );
 }
};

static const std::string chdr(
                  "+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n");
int main(void) throw()
try {
 std::cout << "Checking WxRet ...\n";
 std::cout << "sizeof(WxRet)=" << sizeof(WxRet) << std::endl;
 std::cout << "sizeof(std::logic_error)=" << sizeof(std::logic_error) << std::endl;
 if(sizeof(WxRet)>sizeof(std::logic_error)) {
   std::cerr << "Warning: " <<
    "sizeof(WxRet)>sizeof(std::logic_error)"
   << std::endl;
   WX_THROW( Wx_general_error() );
 }
 t1(); 
 t2();
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
