/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Build: make chk_ptr
*/

#include "wxret.h"
#include "wxptr.h"
#include "wxstr.h"

#if WXPTR_VERSION!=8
#error Test code is for WXPTR_VERSION 8
#endif

class D1 {
  public:
    D1(int v=0) : _v(v) {};
    ~D1() { ++_v; };
    int value(void) const throw() 
       { return _v; };
  private:
    int _v;
};

//
// Test WxPtr
//
static void t1(void)
{

 WxPtr<D1> d1(new D1(102));

 if(d1->value()!=102) {
   WX_THROW( Wx_general_error() );
 }
 if(d1.get()->value()!=102) {
   WX_THROW( Wx_general_error() );
 }
 if((*d1).value()!=102) {
   WX_THROW( Wx_general_error() );
 }

 D1* d1p=d1.release();
 if(d1.get()!=0) {
   WX_THROW( Wx_general_error() );
 }
 if(d1p->value()!=102) {
   WX_THROW( Wx_general_error() );
 }
}

static const WxStr chdr(
                  "+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n");
int main(void) throw()
try {
 std::cout << "Checking wxptr.h ...\n";
 t1();
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
