/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Build: make chk_once
*/
#include "wxret.h"
#include "wxonce.h"
#include "wxstr.h"

#if WXONCE_VERSION!=8
#error Test code is for WXONCE_VERSION 8
#endif

static int t_once_count=0;
static void t_once(void)
{
 ++t_once_count;   // each time this function called, t_once_count incremented.
};

//
// Test WxOnce
//
static void t1(void)
{
 WxOnce a0,a1;
 if(a0.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(a1.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(t_once_count!=0) {
   WX_THROW( Wx_general_error() );  // assertion failure
 }

 a0.once(t_once);
 if(t_once_count!=1) {
   WX_THROW( Wx_general_error() );  // assertion failure
 }
 if(a0.is_default()) {
   WX_THROW( Wx_general_error() );
 }

 // repeat a0
 a0.once(t_once);
 if(t_once_count!=1) {
   WX_THROW( Wx_general_error() );  // assertion failure
 }
 if(a0.is_default()) {
   WX_THROW( Wx_general_error() );
 }

 a0.once(t_once);
 if(t_once_count!=1) {
   WX_THROW( Wx_general_error() );  // assertion failure
 }
 if(a0.is_default()) {
   WX_THROW( Wx_general_error() );
 }

 // use a1 test again
 a1.once(t_once);
 if(t_once_count!=2) {
   WX_THROW( Wx_general_error() );  // assertion failure
 }
 if(a1.is_default()) {
   WX_THROW( Wx_general_error() );
 }

 // repeat on a1
 a1.once(t_once);
 if(t_once_count!=2) {
   WX_THROW( Wx_general_error() );  // assertion failure
 }
 if(a1.is_default()) {
   WX_THROW( Wx_general_error() );
 }
}

//
// Test WxOnce(void(*)(void))
//
static void t2(void)
{
 t_once_count=0;            // reset count
 static WxOnce a0(t_once);  // constructor call
 if(a0.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 if(t_once_count!=1) {
   WX_THROW( Wx_general_error() );  // assertion failure
 }

 // use a0 again
 a0.once(t_once);
 if(t_once_count!=1) {
   WX_THROW( Wx_general_error() );  // assertion failure
 }
 if(a0.is_default()) {
   WX_THROW( Wx_general_error() );
 }
};

static const WxStr chdr(
                  "+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n");
int main(void) throw()
try {
 std::cout << "Checking wxonce.cpp ...\n";
 t1(); 
 t2();
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
