/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Basic test of WxFileStat

   Build: make chk_filestat
*/

#include "wxfilestat.h"
#include <cstdlib>
#include <unistd.h>
#include <sys/types.h>
#include "wxstr.h"

#if WXFILESTAT_VERSION!=8
#error Test code is for WXFILESTAT_VERSION 8
#endif

//
// Check for default object
//
static void t_assert_default(const WxFileStat& dobj)
{
 static WxFileStat tobj;

 if(dobj.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(dobj.is_default()) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(tobj!=dobj) {
   WX_THROW( Wx_general_error() );
 }
 if(tobj==dobj) {
 } else {
   WX_THROW( Wx_general_error() );
 }
};

static void t1(void)
{

 //
 // Check default object
 //
 {
   WxFileStat tmp;
   t_assert_default(tmp);

   WxFileStat tmp2(tmp);
   t_assert_default(tmp2);

   tmp2.assign(tmp);
   t_assert_default(tmp2);

   tmp2.reset();
   t_assert_default(tmp2);
 }

 //
 // Check on non-default tobj
 //
 struct stat sttcwd;
 WxFileStat tobj;
 {
   // set sttcwd with the working directory filestat
   if(::stat(".",&sttcwd)!=0) {
     WX_THROW( Wx_general_error() );
   }
   // set tobj internal stat to sttcwd
   *tobj.wx_stt()=sttcwd;
   if(tobj.is_default()) {
     WX_THROW( Wx_general_error() );
   }
 }

 if(sttcwd.st_mode!=tobj.mode()) {
   WX_THROW( Wx_general_error() );
 }
 if(sttcwd.st_ino!=tobj.ino()) {
   WX_THROW( Wx_general_error() );
 }
 if(sttcwd.st_dev!=tobj.dev()) {
   WX_THROW( Wx_general_error() );
 }
 if(sttcwd.st_nlink!=tobj.nlink()) {
   WX_THROW( Wx_general_error() );
 }
 if(sttcwd.st_uid!=tobj.uid()) {
   WX_THROW( Wx_general_error() );
 }
 if(sttcwd.st_gid!=tobj.gid()) {
   WX_THROW( Wx_general_error() );
 }
 if(sttcwd.st_size!=tobj.size()) {
   WX_THROW( Wx_general_error() );
 }
 if(WxTime(sttcwd.st_atime+28800,0)!=tobj.atime()) {
   WX_THROW( Wx_general_error() );
 }
 if(WxTime(sttcwd.st_ctime+28800,0)!=tobj.ctime()) {
   WX_THROW( Wx_general_error() );
 }
 if(WxTime(sttcwd.st_mtime+28800,0)!=tobj.mtime()) {
   WX_THROW( Wx_general_error() );
 }
 if(tobj.is_dir()!=S_ISDIR(sttcwd.st_mode)) {
   WX_THROW( Wx_general_error() );
 }
 if(tobj.is_chr()!=S_ISCHR(sttcwd.st_mode)) {
   WX_THROW( Wx_general_error() );
 }
 if(tobj.is_blk()!=S_ISBLK(sttcwd.st_mode)) {
   WX_THROW( Wx_general_error() );
 }
 if(tobj.is_reg()!=S_ISREG(sttcwd.st_mode)) {
   WX_THROW( Wx_general_error() );
 }
 if(tobj.is_fifo()!=S_ISFIFO(sttcwd.st_mode)) {
   WX_THROW( Wx_general_error() );
 }

 //
 // Check information directly derived from the system call
 // If uid is not 0, assume it is identical to the uid of cwd (may not be right)
 //
 if(::getuid()!=0) {
   if(tobj.uid()!=::getuid()) {
     WX_THROW( Wx_general_error() );    // may be ok, check this to comment out
   }
   if(tobj.gid()!=::getgid()) {
     WX_THROW( Wx_general_error() );    // may be ok, check this to comment out
   }
 }

 {
   // Test copy constructor
   WxFileStat tmp(tobj);
   if(tmp.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(tmp!=tobj) {
     WX_THROW( Wx_general_error() );
   }
   tmp.reset();
   t_assert_default(tmp);
 }

 {
   // Test copy constructor
   WxFileStat tmp;
   t_assert_default(tmp);

   tmp.assign(tobj);
   if(tmp.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(tmp!=tobj) {
     WX_THROW( Wx_general_error() );
   }
   tmp.reset();
   t_assert_default(tmp);
 }
};

static const WxStr chdr(
                  "+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n");
int main(void) throw()
try {
 std::cout << "Checking wxfilestat.h ...\n";

 if(WxStr(WxFileStat::class_name)!="WxFileStat") {
   WX_THROW( Wx_general_error() );
 }
 t1();
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
