/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Note: This test should be done after chk_ret and chk_errmsg

   Build: make chk_except
*/

#include "wxret.h"
#include "wxstr.h"
#if WXR_EXCEPT_VERSION!=8
#error Test code is for WXR_EXCEPT_VERSION 8
#endif

//
// Test the macro functions defined in wxret.h
//
static void t1(void)
{
 WxRet r;

 //
 // Test WX_THROW( Wx_bad_alloc() )  (Wx_general_error() is thrown if failed)
 //
 try {
   WX_HERE(r); WX_THROW( Wx_bad_alloc() );
   WX_THROW( Wx_general_error() );
 }
 catch(const Wx_bad_alloc& e) {
   const Wx_SrcLoc* p1=r.sli_ptr();
   const Wx_SrcLoc* p2=e.sli_ptr();
   if((p1==0)||(p2==0)) {
     WX_THROW( Wx_general_error() );
   }
   if(p1->src_line()!=p2->src_line()) {
     WX_THROW( Wx_general_error() );
   }
   if(std::strcmp(p1->src_file(),p2->src_file())) {
     WX_THROW( Wx_general_error() );
   }
 }

 //
 // Test WX_THROW( Wx_general_error() ) (Wx_bad_alloc() is thrown if failed)
 //
 try {
   WX_HERE(r); WX_THROW( Wx_general_error() );
   WX_THROW( Wx_bad_alloc() );
 }
 catch(const Wx_general_error& e) {
   const Wx_SrcLoc* p1=r.sli_ptr();
   const Wx_SrcLoc* p2=e.sli_ptr();
   if((p1==0)||(p2==0)) {
     WX_THROW( Wx_bad_alloc() );
   }
   if(p1->src_line()!=p2->src_line()) {
     WX_THROW( Wx_bad_alloc() );
   }
   if(std::strcmp(p1->src_file(),p2->src_file())) {
     WX_THROW( Wx_bad_alloc() );
   }
 }

 //
 // Test WX_THROW( Wx_bad_errno(v) )
 //
 try {
   WX_HERE(r); WX_THROW( Wx_bad_errno(128) );
   WX_THROW( Wx_general_error() );
 }
 catch(const Wx_bad_errno& e) {
   const Wx_SrcLoc* p1=r.sli_ptr();
   const Wx_SrcLoc* p2=e.sli_ptr();
   if((p1==0)||(p2==0)) {
     WX_THROW( Wx_general_error() );
   }
   if(p1->src_line()!=p2->src_line()) {
     WX_THROW( Wx_general_error() );
   }
   if(std::strcmp(p1->src_file(),p2->src_file())) {
     WX_THROW( Wx_general_error() );
   }
   if(e.value()!=128) {
     WX_THROW( Wx_general_error() );
   }
 }
}

//
// Test inheritance of the exception class
//
static void t2(void)
{
 try {
   WX_THROW( Wx_bad_alloc() );
   WX_THROW( Wx_general_error() );
 }
 catch(const std::bad_alloc& e) {
   if(std::strcmp(e.what(),Wx_bad_alloc::class_name)!=0) { // Not Wx_bad_alloc
     throw;
   }
 }
 catch(...) {
   WX_THROW( Wx_general_error() );
 };

 try {
   throw Wx_except();
   WX_THROW( Wx_general_error() );
 }
 catch(const std::exception& e) {
   if(std::strcmp(e.what(),Wx_except::class_name)!=0) {  // Not Wx_except
     throw;
   }
 }
 catch(...) {
   WX_THROW( Wx_general_error() );
 };

 try {
   WX_THROW( Wx_general_error() );
   WX_THROW( Wx_bad_alloc() );
 }
 catch(const Wx_except& e) {
   if(std::strcmp(e.what(),Wx_general_error::class_name)!=0) { // Not Wx_general_error
     throw;
   }
 }
 catch(...) {
   WX_THROW( Wx_general_error() );
 };

 try {
   WX_THROW( Wx_bad_alloc() );
   WX_THROW( Wx_general_error() );
 }
 catch(const Wx_except& e) {
   //if(std::strcmp(e.what(),Wx_bad_errno::class_name)!=0) // Not Wx_bad_alloc
   throw;
 }
 catch(const Wx_bad_alloc&) {
   // as expected
 }
 catch(...) {
   WX_THROW( Wx_general_error() );
 };
};

//
// Check application can use WxLib-exception
//
class App_bad_alloc : public Wx_bad_alloc {
  public:
    App_bad_alloc() throw()
         : Wx_bad_alloc() {};
    const Wx_SrcLoc* sli_ptr(void) const throw()
         { return Wx_bad_alloc::sli_ptr(); };
    const App_bad_alloc& set_sli(const Wx_SrcLoc* s) throw()
         { Wx_bad_alloc::set_sli(s); return(*this); };
};

class App_except: public Wx_except {
  public:
    App_except() throw()
         : Wx_except() {};
    const Wx_SrcLoc* sli_ptr(void) const throw()
         { return Wx_except::sli_ptr(); };
    const App_except& set_sli(const Wx_SrcLoc* s) throw()
         { Wx_except::set_sli(s); return(*this); };
};

class App_general_error : public Wx_general_error {
  public:
    App_general_error() throw()
         : Wx_general_error() {};
    const Wx_SrcLoc* sli_ptr(void) const throw()
         { return Wx_general_error::sli_ptr(); };
    const App_general_error& set_sli(const Wx_SrcLoc* s) throw()
         { Wx_general_error::set_sli(s); return(*this); };
};

class App_bad_errno : public Wx_bad_errno {
  public:
    App_bad_errno() throw()
         : Wx_bad_errno() {};
    App_bad_errno(int v) throw()
         : Wx_bad_errno(v) {};
    const Wx_SrcLoc* sli_ptr(void) const throw()
         { return Wx_bad_errno::sli_ptr(); };
    const App_bad_errno& set_sli(const Wx_SrcLoc* s) throw()
         { Wx_bad_errno::set_sli(s); return(*this); };
};

static void t_app_except(void)
{
 WxRet r;

 // check App_bad_alloc
 try {
   WX_HERE(r); WX_THROW( App_bad_alloc() );
   WX_THROW( Wx_general_error() );
 }
 catch(const App_bad_alloc& e) {
   if((*r.sli_ptr())!=(*e.sli_ptr())) {
     WX_THROW( Wx_general_error() );
   }
   // FALLTHROUGH
 }
 catch(...) {
   WX_THROW( Wx_general_error() );
 };

 // check App_except
 try {
   WX_HERE(r); WX_THROW( App_except() );
   WX_THROW( Wx_general_error() );
 }
 catch(const App_except& e) {
   if((*r.sli_ptr())!=(*e.sli_ptr())) {
     WX_THROW( Wx_general_error() );
   }
   // FALLTHROUGH
 }
 catch(...) {
   WX_THROW( Wx_general_error() );
 };

 // check App_general_error
 try {
   WX_HERE(r); WX_THROW( App_general_error() );
   WX_THROW( Wx_general_error() );
 }
 catch(const App_general_error& e) {
   if((*r.sli_ptr())!=(*e.sli_ptr())) {
     WX_THROW( Wx_general_error() );
   }
   // FALLTHROUGH
 }
 catch(...) {
   WX_THROW( Wx_general_error() );
 };

 // check App_bad_errno
 try {
   WX_HERE(r); WX_THROW( App_bad_errno(3) );
   WX_THROW( Wx_general_error() );
 }
 catch(const App_bad_errno& e) {
   if((*r.sli_ptr())!=(*e.sli_ptr())) {
     WX_THROW( Wx_general_error() );
   }
   if(e.value()!=3) {
     WX_THROW( Wx_general_error() );
   }
   // FALLTHROUGH
 }
 catch(...) {
   WX_THROW( Wx_general_error() );
 };
};

static const WxStr chdr(
                  "+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n");
int main(void) throw()
try {
 std::cout << "Checking wxr_except.cpp ...\n";
 std::cout << "sizeof(Wx_bad_alloc)=" << sizeof(Wx_bad_alloc) << std::endl;
 std::cout << "sizeof(Wx_except)=" << sizeof(Wx_except) << std::endl;
 std::cout << "sizeof(Wx_general_error)=" << sizeof(Wx_general_error) << std::endl;
 std::cout << "sizeof(Wx_bad_errno)=" << sizeof(Wx_bad_errno) << std::endl;

 if(sizeof(Wx_bad_alloc)>sizeof(std::logic_error)) {
   std::cerr << "Warning: " <<
    "sizeof(Wx_bad_alloc)>sizeof(std::logic_error)"
   << std::endl;
 }
 if(sizeof(Wx_except)>sizeof(std::logic_error)) {
   std::cerr << "Warning: " <<
    "sizeof(Wx_except)>sizeof(std::logic_error)"
   << std::endl;
 }
 if(sizeof(Wx_general_error)>sizeof(std::logic_error)) {
   std::cerr << "Warning: " <<
    "sizeof(Wx_general_error)>sizeof(std::logic_error)"
   << std::endl;
 }
 if(sizeof(Wx_bad_errno)>sizeof(std::logic_error)) {
   std::cerr << "Warning: " <<
    "sizeof(Wx_bad_errno)>sizeof(std::logic_error)"
   << std::endl;
 }

 t1(); 
 t2();
 t_app_except();
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
