/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Build: make chk_errmsg
*/

#include "wxret.h"
#include "wxstr.h"
#if WXR_ERRMSG_VERSION!=8
#error Test code is for WXR_ERRMSG_VERSION 8
#endif

//
// Test the public interface of WxErrMsg
//
static void t1(void)
{
 WxErrMsg e1;            // default constructor
 WxErrMsg e2(ENOENT);    // construct by errno
 WxErrMsg e3(e2);        // constructor by copy
 WxErrMsg e4(0);         // construct by errno (OK object)

 if(::strcmp(WxErrMsg().c_errstr(),"Default error string")!=0) {
   WX_THROW(Wx_general_error());
 }

 //
 // Basic construct and compare
 //
 if(e1.is_default()==false) {
   WX_THROW(Wx_general_error());
 }
 if(e2.is_default()==true) {
   WX_THROW( Wx_general_error() );
 }
 if(e3.is_default()==true) {
   WX_THROW( Wx_general_error() );
 }
 if(e1==e2) {
   WX_THROW( Wx_general_error() );
 }
 if(e1!=e2) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(e2!=e3) {
   WX_THROW( Wx_general_error() );
 }
 if(e2==e3) {
 } else {
   WX_THROW( Wx_general_error() );
 }

 //
 // Test OK==WxErrMsg(0)
 //
 if(WxErrMsg(0)!=OK) {
   WX_THROW( Wx_general_error() );
 }

 if(e1==OK) {
   WX_THROW( Wx_general_error() );
 }
 if(e1!=OK) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(e2==OK) {
   WX_THROW( Wx_general_error() );
 }
 if(e2!=OK) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(e4==OK) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(e4!=OK) {
   WX_THROW( Wx_general_error() );
 }
 if(e4.is_default()) {
   WX_THROW( Wx_general_error() );
 }

 //
 // Test reset
 //
 e4.reset();
 if(e4.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(e2.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 e4.reset(e2);
 if(e4!=e2) {
   WX_THROW( Wx_general_error() );
 }
 e4.reset(WXM_EBADF);
 if(e4!=WXM_EBADF) {
   WX_THROW( Wx_general_error() );
 }

 //
 // Test assign
 //
 e4.reset();
 if(e4.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(e2.is_default()) {
   WX_THROW( Wx_general_error() );
 }
 e4.assign(e2);
 if(e4!=e2) {
   WX_THROW( Wx_general_error() );
 }
 e4.assign(WXM_EBADF);
 if(e4!=WXM_EBADF) {
   WX_THROW( Wx_general_error() );
 }
 if(e4.assign(-1)!=EINVAL) {
   WX_THROW( Wx_general_error() );
 }
 e4.reset();

 //
 // Test operator=
 //
 if(e4==e2) {
   WX_THROW( Wx_general_error() );
 }
 e4=e2;
 if(e4!=e2) {
   WX_THROW( Wx_general_error() );
 }
 e4=WXM_EBADF;
 if(e4!=WXM_EBADF) {
   WX_THROW( Wx_general_error() );
 }
 try {
  e4=200;
  WX_THROW( Wx_general_error() );
 }
 catch(const Wx_bad_errno& e) {
   if(e.value()!=200) {
     throw;
   }
 }
 e4.reset();

 //
 // Test some c_errno
 //
 if(WXM_EPERM.c_errno()!=EPERM) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOENT.c_errno()!=ENOENT) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ESRCH.c_errno()!=ESRCH) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EINTR.c_errno()!=EINTR) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENETRESET.c_errno()!=ENETRESET) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EMEDIUMTYPE.c_errno()!=EMEDIUMTYPE) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_E127.c_errno()!=127) {
   WX_THROW( Wx_general_error() );
 }

 //
 // Test enroll
 //
 const char* tem="Message for test";
 WxErrMsg ne1=WxErrMsg::enroll(tem);
 WxErrMsg ne2=WxErrMsg::enroll(tem);
 if(ne1!=ne2) {
   WX_THROW( Wx_general_error() );
 }
 if(::strcmp(ne1.c_errstr(),ne2.c_errstr())!=0) {
   WX_THROW( Wx_general_error() );
 }
};

//
// Test the mapped errno 0-127
//
static void t2(void)
{
 if(OK!=WxErrMsg(0)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EPERM!=WxErrMsg(EPERM)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOENT!=WxErrMsg(ENOENT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ESRCH!=WxErrMsg(ESRCH)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EINTR!=WxErrMsg(EINTR)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EIO!=WxErrMsg(EIO)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENXIO!=WxErrMsg(ENXIO)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_E2BIG!=WxErrMsg(E2BIG)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOEXEC!=WxErrMsg(ENOEXEC)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EBADF!=WxErrMsg(EBADF)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ECHILD!=WxErrMsg(ECHILD)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EAGAIN!=WxErrMsg(EAGAIN)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOMEM!=WxErrMsg(ENOMEM)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EACCES!=WxErrMsg(EACCES)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EFAULT!=WxErrMsg(EFAULT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOTBLK!=WxErrMsg(ENOTBLK)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EBUSY!=WxErrMsg(EBUSY)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EEXIST!=WxErrMsg(EEXIST)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EXDEV!=WxErrMsg(EXDEV)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENODEV!=WxErrMsg(ENODEV)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOTDIR!=WxErrMsg(ENOTDIR)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EISDIR!=WxErrMsg(EISDIR)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EINVAL!=WxErrMsg(EINVAL)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENFILE!=WxErrMsg(ENFILE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EMFILE!=WxErrMsg(EMFILE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOTTY!=WxErrMsg(ENOTTY)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ETXTBSY!=WxErrMsg(ETXTBSY)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EFBIG!=WxErrMsg(EFBIG)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOSPC!=WxErrMsg(ENOSPC)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ESPIPE!=WxErrMsg(ESPIPE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EROFS!=WxErrMsg(EROFS)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EMLINK!=WxErrMsg(EMLINK)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EPIPE!=WxErrMsg(EPIPE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EDOM!=WxErrMsg(EDOM)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ERANGE!=WxErrMsg(ERANGE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EDEADLK!=WxErrMsg(EDEADLK)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENAMETOOLONG!=WxErrMsg(ENAMETOOLONG)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOLCK!=WxErrMsg(ENOLCK)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOSYS!=WxErrMsg(ENOSYS)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOTEMPTY!=WxErrMsg(ENOTEMPTY)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ELOOP!=WxErrMsg(ELOOP)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EWOULDBLOCK!=WxErrMsg(EWOULDBLOCK)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_E41!=WxErrMsg(41)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOMSG!=WxErrMsg(ENOMSG)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EIDRM!=WxErrMsg(EIDRM)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ECHRNG!=WxErrMsg(ECHRNG)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EL2NSYNC!=WxErrMsg(EL2NSYNC)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EL3HLT!=WxErrMsg(EL3HLT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EL3RST!=WxErrMsg(EL3RST)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ELNRNG!=WxErrMsg(ELNRNG)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EUNATCH!=WxErrMsg(EUNATCH)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOCSI!=WxErrMsg(ENOCSI)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EL2HLT!=WxErrMsg(EL2HLT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EBADE!=WxErrMsg(EBADE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EBADR!=WxErrMsg(EBADR)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EXFULL!=WxErrMsg(EXFULL)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOANO!=WxErrMsg(ENOANO)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EBADRQC!=WxErrMsg(EBADRQC)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EBADSLT!=WxErrMsg(EBADSLT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EDEADLOCK!=WxErrMsg(EDEADLOCK)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_E58!=WxErrMsg(58)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EBFONT!=WxErrMsg(EBFONT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOSTR!=WxErrMsg(ENOSTR)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENODATA!=WxErrMsg(ENODATA)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ETIME!=WxErrMsg(ETIME)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOSR!=WxErrMsg(ENOSR)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENONET!=WxErrMsg(ENONET)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOPKG!=WxErrMsg(ENOPKG)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EREMOTE!=WxErrMsg(EREMOTE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOLINK!=WxErrMsg(ENOLINK)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EADV!=WxErrMsg(EADV)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ESRMNT!=WxErrMsg(ESRMNT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ECOMM!=WxErrMsg(ECOMM)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EPROTO!=WxErrMsg(EPROTO)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EMULTIHOP!=WxErrMsg(EMULTIHOP)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EDOTDOT!=WxErrMsg(EDOTDOT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EBADMSG!=WxErrMsg(EBADMSG)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EOVERFLOW!=WxErrMsg(EOVERFLOW)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOTUNIQ!=WxErrMsg(ENOTUNIQ)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EBADFD!=WxErrMsg(EBADFD)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EREMCHG!=WxErrMsg(EREMCHG)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ELIBACC!=WxErrMsg(ELIBACC)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ELIBBAD!=WxErrMsg(ELIBBAD)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ELIBSCN!=WxErrMsg(ELIBSCN)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ELIBMAX!=WxErrMsg(ELIBMAX)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ELIBEXEC!=WxErrMsg(ELIBEXEC)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EILSEQ!=WxErrMsg(EILSEQ)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ERESTART!=WxErrMsg(ERESTART)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ESTRPIPE!=WxErrMsg(ESTRPIPE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EUSERS!=WxErrMsg(EUSERS)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOTSOCK!=WxErrMsg(ENOTSOCK)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EDESTADDRREQ!=WxErrMsg(EDESTADDRREQ)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EMSGSIZE!=WxErrMsg(EMSGSIZE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EPROTOTYPE!=WxErrMsg(EPROTOTYPE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOPROTOOPT!=WxErrMsg(ENOPROTOOPT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EPROTONOSUPPORT!=WxErrMsg(EPROTONOSUPPORT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ESOCKTNOSUPPORT!=WxErrMsg(ESOCKTNOSUPPORT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EOPNOTSUPP!=WxErrMsg(EOPNOTSUPP)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EPFNOSUPPORT!=WxErrMsg(EPFNOSUPPORT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EAFNOSUPPORT!=WxErrMsg(EAFNOSUPPORT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EADDRINUSE!=WxErrMsg(EADDRINUSE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EADDRNOTAVAIL!=WxErrMsg(EADDRNOTAVAIL)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENETDOWN!=WxErrMsg(ENETDOWN)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENETUNREACH!=WxErrMsg(ENETUNREACH)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENETRESET!=WxErrMsg(ENETRESET)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ECONNABORTED!=WxErrMsg(ECONNABORTED)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ECONNRESET!=WxErrMsg(ECONNRESET)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOBUFS!=WxErrMsg(ENOBUFS)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EISCONN!=WxErrMsg(EISCONN)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOTCONN!=WxErrMsg(ENOTCONN)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ESHUTDOWN!=WxErrMsg(ESHUTDOWN)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ETOOMANYREFS!=WxErrMsg(ETOOMANYREFS)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ETIMEDOUT!=WxErrMsg(ETIMEDOUT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ECONNREFUSED!=WxErrMsg(ECONNREFUSED)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EHOSTDOWN!=WxErrMsg(EHOSTDOWN)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EHOSTUNREACH!=WxErrMsg(EHOSTUNREACH)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EALREADY!=WxErrMsg(EALREADY)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EINPROGRESS!=WxErrMsg(EINPROGRESS)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ESTALE!=WxErrMsg(ESTALE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EUCLEAN!=WxErrMsg(EUCLEAN)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOTNAM!=WxErrMsg(ENOTNAM)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENAVAIL!=WxErrMsg(ENAVAIL)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EISNAM!=WxErrMsg(EISNAM)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EREMOTEIO!=WxErrMsg(EREMOTEIO)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EDQUOT!=WxErrMsg(EDQUOT)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_ENOMEDIUM!=WxErrMsg(ENOMEDIUM)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EMEDIUMTYPE!=WxErrMsg(EMEDIUMTYPE)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_E125!=WxErrMsg(125)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_E126!=WxErrMsg(126)) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_E127!=WxErrMsg(127)) {
   WX_THROW( Wx_general_error() );
 }

 // Test EWOULDBLOCK EAGAIN
 if(WXM_EWOULDBLOCK!=WXM_EAGAIN) {  // EWOULDBLOCK and EAGAIN should be identical
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EDEADLK!=WXM_EDEADLOCK) {   // EDEADLOCK and EDEADLK should be identical
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EWOULDBLOCK.c_errno()!=EAGAIN) {
   WX_THROW( Wx_general_error() );
 }
 if(WXM_EDEADLK.c_errno()!=EDEADLK) {
   WX_THROW( Wx_general_error() );
 }
}

static const std::string chdr(
                  "+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n");
int main(void) throw()
try {
 std::cout << "Checking WxErrMsg ...\n";
 t1(); 
 t2();

 //
 // Print errno 0-127
 //
 std::cout << "--- Print errmsg mapped errno 0-127\n";
 for(int i=0; i<=WxErrMsg::MaxErrNo; ++i) {
   WxErrMsg ei(i);
   std::cout << i << "  " << ei.c_errstr() << std::endl;
 }

 //
 // Print the WxLib added errmsg's
 //
 std::cout << std::endl;
 std::cout<< "WXM_THRDCAN  " << WXM_THRDCAN.c_errstr() << std::endl;
 std::cout << "WXM_NDEFAULT " << WXM_NDEFAULT.c_errstr() << std::endl;
 std::cout << "WXM_DIVZERO " << WXM_DIVZERO.c_errstr() << std::endl;
 std::cout << "WXM_MATHNEG " << WXM_MATHNEG.c_errstr() << std::endl;
 std::cout << "WXM_VFDIS " << WXM_VFDIS.c_errstr() << std::endl;
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
}
