/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Basic test of WxDirEnt

   Build: make chk_dirent
*/

#include "wxdirent.h"
#include <cstdlib>
#include <unistd.h>
#include <sys/types.h>

#if WXDIRENT_VERSION!=8
#error Test code is for WXDIRENT_VERSION 8
#endif

//
// Check for default object
//
static void t_assert_default(const WxDirEnt& dobj)
{
 static WxDirEnt tobj;

 if(((WxDirEnt&)dobj).wx_dent_ptr()->d_name[0]!=0) {
   WX_THROW( Wx_general_error() );
 }
 if(dobj.is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
 if(dobj.is_default()) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(tobj!=dobj) {
   WX_THROW( Wx_general_error() );
 }
 if(tobj==dobj) {
 } else {
   WX_THROW( Wx_general_error() );
 }
 if(dobj.filename().is_default()==false) {
   WX_THROW( Wx_general_error() );
 }
};

static void t1(void)
{

 //
 // Check default object
 //
 {
   WxDirEnt tmp;
   t_assert_default(tmp);

   WxDirEnt tmp2(tmp);
   t_assert_default(tmp2);

   tmp2.assign(tmp);
   t_assert_default(tmp2);

   tmp2.reset();
   t_assert_default(tmp2);
 }

 //
 // Check on non-default tobj
 //
 WxDirEnt NObj;
 {
   // make NObj d_name='n'+0;
   NObj.wx_dent_ptr()->d_name[0]='n';
   NObj.wx_dent_ptr()->d_name[1]=0;
 }
 if(NObj.is_default()) {
   WX_THROW( Wx_general_error() );
 }

 // Test copy constructor
 {
   WxDirEnt tmp(NObj);
   if(tmp.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(tmp!=NObj) {
     WX_THROW( Wx_general_error() );
   }
   if(tmp==NObj) {
   } else {
     WX_THROW( Wx_general_error() );
   }
  
   if(tmp.filename()!=NObj.filename()) {
     WX_THROW( Wx_general_error() );
   }
   tmp.reset();
   t_assert_default(tmp);
 }

 // Test assign/reset
 {
   WxDirEnt tmp;
   t_assert_default(tmp);

   tmp.assign(NObj);
   if(tmp.is_default()) {
     WX_THROW( Wx_general_error() );
   }
   if(tmp!=NObj) {
     WX_THROW( Wx_general_error() );
   }
   tmp.assign(NObj); // twice assign of non-default object
   if(tmp!=NObj) {
     WX_THROW( Wx_general_error() );
   }

   tmp.reset();
   t_assert_default(tmp);
 }
};

static const WxStr chdr(
                  "+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n");
int main(void) throw()
try {
 std::cout << "Checking wxdirent.h ...\n";

 if(WxStr(WxDirEnt::class_name)!="WxDirEnt") {
   WX_THROW( Wx_general_error() );
 }
 t1();
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
